package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{CreatedAt, GenericString, Arn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeploymentJob(
    arn: Optional[Arn] = Optional.Absent,
    fleet: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.DeploymentStatus] =
      Optional.Absent,
    deploymentApplicationConfigs: Optional[
      Iterable[zio.aws.robomaker.model.DeploymentApplicationConfig]
    ] = Optional.Absent,
    deploymentConfig: Optional[zio.aws.robomaker.model.DeploymentConfig] =
      Optional.Absent,
    failureReason: Optional[GenericString] = Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.DeploymentJobErrorCode] =
      Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeploymentJob = {
    import DeploymentJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeploymentJob
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(fleet.map(value => Arn.unwrap(value): java.lang.String))(
        _.fleet
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        deploymentApplicationConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deploymentApplicationConfigs)
      .optionallyWith(deploymentConfig.map(value => value.buildAwsValue()))(
        _.deploymentConfig
      )
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeploymentJob.ReadOnly =
    zio.aws.robomaker.model.DeploymentJob.wrap(buildAwsValue())
}
object DeploymentJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeploymentJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeploymentJob =
      zio.aws.robomaker.model.DeploymentJob(
        arn.map(value => value),
        fleet.map(value => value),
        status.map(value => value),
        deploymentApplicationConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deploymentConfig.map(value => value.asEditable),
        failureReason.map(value => value),
        failureCode.map(value => value),
        createdAt.map(value => value)
      )
    def arn: Optional[Arn]
    def fleet: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.DeploymentStatus]
    def deploymentApplicationConfigs: Optional[
      List[zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly]
    ]
    def deploymentConfig
        : Optional[zio.aws.robomaker.model.DeploymentConfig.ReadOnly]
    def failureReason: Optional[GenericString]
    def failureCode: Optional[zio.aws.robomaker.model.DeploymentJobErrorCode]
    def createdAt: Optional[CreatedAt]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getFleet: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("fleet", fleet)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDeploymentApplicationConfigs: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deploymentApplicationConfigs",
      deploymentApplicationConfigs
    )
    def getDeploymentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.DeploymentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentConfig", deploymentConfig)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.DeploymentJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentJob
  ) extends zio.aws.robomaker.model.DeploymentJob.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val fleet: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleet())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status: Optional[zio.aws.robomaker.model.DeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.robomaker.model.DeploymentStatus.wrap(value))
    override val deploymentApplicationConfigs: Optional[
      List[zio.aws.robomaker.model.DeploymentApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentApplicationConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.DeploymentApplicationConfig.wrap(item)
        }.toList
      )
    override val deploymentConfig
        : Optional[zio.aws.robomaker.model.DeploymentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentConfig())
        .map(value => zio.aws.robomaker.model.DeploymentConfig.wrap(value))
    override val failureReason: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: GenericString)
    override val failureCode
        : Optional[zio.aws.robomaker.model.DeploymentJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.DeploymentJobErrorCode.wrap(value)
        )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentJob
  ): zio.aws.robomaker.model.DeploymentJob.ReadOnly = new Wrapper(impl)
}
