package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeWorldGenerationJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest = {
    import DescribeWorldGenerationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldGenerationJobRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldGenerationJobRequest
      .wrap(buildAwsValue())
}
object DescribeWorldGenerationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldGenerationJobRequest =
      zio.aws.robomaker.model.DescribeWorldGenerationJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest
  ) extends zio.aws.robomaker.model.DescribeWorldGenerationJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest
  ): zio.aws.robomaker.model.DescribeWorldGenerationJobRequest.ReadOnly =
    new Wrapper(impl)
}
