package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeWorldGenerationJobResponse(
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.WorldGenerationJobStatus] =
      Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      Optional.Absent,
    failureReason: Optional[GenericString] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    template: Optional[Arn] = Optional.Absent,
    worldCount: Optional[zio.aws.robomaker.model.WorldCount] = Optional.Absent,
    finishedWorldsSummary: Optional[
      zio.aws.robomaker.model.FinishedWorldsSummary
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    worldTags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse = {
    import DescribeWorldGenerationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(worldCount.map(value => value.buildAwsValue()))(
        _.worldCount
      )
      .optionallyWith(
        finishedWorldsSummary.map(value => value.buildAwsValue())
      )(_.finishedWorldsSummary)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        worldTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.worldTags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldGenerationJobResponse
      .wrap(buildAwsValue())
}
object DescribeWorldGenerationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldGenerationJobResponse =
      zio.aws.robomaker.model.DescribeWorldGenerationJobResponse(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        failureCode.map(value => value),
        failureReason.map(value => value),
        clientRequestToken.map(value => value),
        template.map(value => value),
        worldCount.map(value => value.asEditable),
        finishedWorldsSummary.map(value => value.asEditable),
        tags.map(value => value),
        worldTags.map(value => value)
      )
    def arn: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.WorldGenerationJobStatus]
    def createdAt: Optional[CreatedAt]
    def failureCode
        : Optional[zio.aws.robomaker.model.WorldGenerationJobErrorCode]
    def failureReason: Optional[GenericString]
    def clientRequestToken: Optional[ClientRequestToken]
    def template: Optional[Arn]
    def worldCount: Optional[zio.aws.robomaker.model.WorldCount.ReadOnly]
    def finishedWorldsSummary
        : Optional[zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def worldTags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldGenerationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.WorldGenerationJobErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getWorldCount
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      AwsError.unwrapOptionField("worldCount", worldCount)
    def getFinishedWorldsSummary: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly
    ] =
      AwsError.unwrapOptionField("finishedWorldsSummary", finishedWorldsSummary)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWorldTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("worldTags", worldTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
  ) extends zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Optional[zio.aws.robomaker.model.WorldGenerationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.robomaker.model.WorldGenerationJobStatus.wrap(value)
        )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val failureCode
        : Optional[zio.aws.robomaker.model.WorldGenerationJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.WorldGenerationJobErrorCode.wrap(value)
        )
    override val failureReason: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: GenericString)
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val template: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val worldCount
        : Optional[zio.aws.robomaker.model.WorldCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldCount())
        .map(value => zio.aws.robomaker.model.WorldCount.wrap(value))
    override val finishedWorldsSummary
        : Optional[zio.aws.robomaker.model.FinishedWorldsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finishedWorldsSummary())
        .map(value => zio.aws.robomaker.model.FinishedWorldsSummary.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val worldTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.robomaker.model.primitives.TagKey(
                key
              ) -> zio.aws.robomaker.model.primitives.TagValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse
  ): zio.aws.robomaker.model.DescribeWorldGenerationJobResponse.ReadOnly =
    new Wrapper(impl)
}
