package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  ClientRequestToken,
  TagValue,
  TemplateName,
  Arn,
  LastUpdatedAt,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeWorldTemplateResponse(
    arn: Optional[Arn] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    name: Optional[TemplateName] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    version: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse = {
    import DescribeWorldTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeWorldTemplateResponse.wrap(buildAwsValue())
}
object DescribeWorldTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeWorldTemplateResponse =
      zio.aws.robomaker.model.DescribeWorldTemplateResponse(
        arn.map(value => value),
        clientRequestToken.map(value => value),
        name.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        tags.map(value => value),
        version.map(value => value)
      )
    def arn: Optional[Arn]
    def clientRequestToken: Optional[ClientRequestToken]
    def name: Optional[TemplateName]
    def createdAt: Optional[CreatedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def tags: Optional[Map[TagKey, TagValue]]
    def version: Optional[GenericString]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
  ) extends zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val name: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val version: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse
  ): zio.aws.robomaker.model.DescribeWorldTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
