package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListSimulationJobBatchesResponse(
    simulationJobBatchSummaries: Optional[
      Iterable[zio.aws.robomaker.model.SimulationJobBatchSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse = {
    import ListSimulationJobBatchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse
      .builder()
      .optionallyWith(
        simulationJobBatchSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationJobBatchSummaries)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly =
    zio.aws.robomaker.model.ListSimulationJobBatchesResponse
      .wrap(buildAwsValue())
}
object ListSimulationJobBatchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListSimulationJobBatchesResponse =
      zio.aws.robomaker.model.ListSimulationJobBatchesResponse(
        simulationJobBatchSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def simulationJobBatchSummaries: Optional[
      List[zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getSimulationJobBatchSummaries: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationJobBatchSummaries",
      simulationJobBatchSummaries
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse
  ) extends zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly {
    override val simulationJobBatchSummaries: Optional[
      List[zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.simulationJobBatchSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationJobBatchSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse
  ): zio.aws.robomaker.model.ListSimulationJobBatchesResponse.ReadOnly =
    new Wrapper(impl)
}
