package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.GenericString
import scala.jdk.CollectionConverters.*
final case class NetworkInterface(
    networkInterfaceId: Optional[GenericString] = Optional.Absent,
    privateIpAddress: Optional[GenericString] = Optional.Absent,
    publicIpAddress: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.NetworkInterface
      .builder()
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .optionallyWith(publicIpAddress.map(value => value: java.lang.String))(
        _.publicIpAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.NetworkInterface.ReadOnly =
    zio.aws.robomaker.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.NetworkInterface =
      zio.aws.robomaker.model.NetworkInterface(
        networkInterfaceId.map(value => value),
        privateIpAddress.map(value => value),
        publicIpAddress.map(value => value)
      )
    def networkInterfaceId: Optional[GenericString]
    def privateIpAddress: Optional[GenericString]
    def publicIpAddress: Optional[GenericString]
    def getNetworkInterfaceId: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.NetworkInterface
  ) extends zio.aws.robomaker.model.NetworkInterface.ReadOnly {
    override val networkInterfaceId: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => value: GenericString)
    override val privateIpAddress: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddress())
        .map(value => value: GenericString)
    override val publicIpAddress: Optional[GenericString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIpAddress())
        .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.NetworkInterface
  ): zio.aws.robomaker.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
