package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.RenderingEngineVersionType
import scala.jdk.CollectionConverters.*
final case class RenderingEngine(
    name: Optional[zio.aws.robomaker.model.RenderingEngineType] =
      Optional.Absent,
    version: Optional[RenderingEngineVersionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RenderingEngine = {
    import RenderingEngine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RenderingEngine
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        version.map(value =>
          RenderingEngineVersionType.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RenderingEngine.ReadOnly =
    zio.aws.robomaker.model.RenderingEngine.wrap(buildAwsValue())
}
object RenderingEngine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RenderingEngine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RenderingEngine =
      zio.aws.robomaker.model
        .RenderingEngine(name.map(value => value), version.map(value => value))
    def name: Optional[zio.aws.robomaker.model.RenderingEngineType]
    def version: Optional[RenderingEngineVersionType]
    def getName
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RenderingEngineType] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, RenderingEngineVersionType] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RenderingEngine
  ) extends zio.aws.robomaker.model.RenderingEngine.ReadOnly {
    override val name: Optional[zio.aws.robomaker.model.RenderingEngineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.robomaker.model.RenderingEngineType.wrap(value))
    override val version: Optional[RenderingEngineVersionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.robomaker.model.primitives.RenderingEngineVersionType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RenderingEngine
  ): zio.aws.robomaker.model.RenderingEngine.ReadOnly = new Wrapper(impl)
}
