package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait RobotSoftwareSuiteType {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType
}
object RobotSoftwareSuiteType {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType
  ): zio.aws.robomaker.model.RobotSoftwareSuiteType = value match {
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.ROS =>
      val r = ROS
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.ROS2 =>
      val r = ROS2
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.GENERAL =>
      val r = General
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.RobotSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.UNKNOWN_TO_SDK_VERSION
  }
  case object ROS extends zio.aws.robomaker.model.RobotSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.ROS
  }
  case object ROS2 extends zio.aws.robomaker.model.RobotSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.ROS2
  }
  case object General extends zio.aws.robomaker.model.RobotSoftwareSuiteType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteType.GENERAL
  }
}
