package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait RobotStatus {
  def unwrap: software.amazon.awssdk.services.robomaker.model.RobotStatus
}
object RobotStatus {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.RobotStatus
  ): zio.aws.robomaker.model.RobotStatus = value match {
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.REGISTERED =>
      val r = Registered
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.PENDING_NEW_DEPLOYMENT =>
      val r = PendingNewDeployment
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.DEPLOYING =>
      val r = Deploying
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.IN_SYNC =>
      val r = InSync
      r
    case software.amazon.awssdk.services.robomaker.model.RobotStatus.NO_RESPONSE =>
      val r = NoResponse
      r
  }
  case object unknownToSdkVersion extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Available extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.AVAILABLE
  }
  case object Registered extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.REGISTERED
  }
  case object PendingNewDeployment extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.PENDING_NEW_DEPLOYMENT
  }
  case object Deploying extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.DEPLOYING
  }
  case object Failed extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.FAILED
  }
  case object InSync extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.IN_SYNC
  }
  case object NoResponse extends zio.aws.robomaker.model.RobotStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotStatus =
      software.amazon.awssdk.services.robomaker.model.RobotStatus.NO_RESPONSE
  }
}
