package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait SimulationJobErrorCode {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode
}
object SimulationJobErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode
  ): zio.aws.robomaker.model.SimulationJobErrorCode = value match {
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INTERNAL_SERVICE_ERROR =>
      val r = InternalServiceError
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ROBOT_APPLICATION_CRASH =>
      val r = RobotApplicationCrash
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SIMULATION_APPLICATION_CRASH =>
      val r = SimulationApplicationCrash
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ROBOT_APPLICATION_HEALTH_CHECK_FAILURE =>
      val r = RobotApplicationHealthCheckFailure
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SIMULATION_APPLICATION_HEALTH_CHECK_FAILURE =>
      val r = SimulationApplicationHealthCheckFailure
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_ROBOT_APPLICATION =>
      val r = BadPermissionsRobotApplication
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_SIMULATION_APPLICATION =>
      val r = BadPermissionsSimulationApplication
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_S3_OBJECT =>
      val r = BadPermissionsS3Object
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_S3_OUTPUT =>
      val r = BadPermissionsS3Output
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_CLOUDWATCH_LOGS =>
      val r = BadPermissionsCloudwatchLogs
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SUBNET_IP_LIMIT_EXCEEDED =>
      val r = SubnetIpLimitExceeded
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ENI_LIMIT_EXCEEDED =>
      val r = ENILimitExceeded
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_USER_CREDENTIALS =>
      val r = BadPermissionsUserCredentials
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_BUNDLE_ROBOT_APPLICATION =>
      val r = InvalidBundleRobotApplication
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_BUNDLE_SIMULATION_APPLICATION =>
      val r = InvalidBundleSimulationApplication
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_S3_RESOURCE =>
      val r = InvalidS3Resource
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.THROTTLING_ERROR =>
      val r = ThrottlingError
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.LIMIT_EXCEEDED =>
      val r = LimitExceeded
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.MISMATCHED_ETAG =>
      val r = MismatchedEtag
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ROBOT_APPLICATION_VERSION_MISMATCHED_ETAG =>
      val r = RobotApplicationVersionMismatchedEtag
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SIMULATION_APPLICATION_VERSION_MISMATCHED_ETAG =>
      val r = SimulationApplicationVersionMismatchedEtag
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.RESOURCE_NOT_FOUND =>
      val r = ResourceNotFound
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.REQUEST_THROTTLED =>
      val r = RequestThrottled
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BATCH_TIMED_OUT =>
      val r = BatchTimedOut
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BATCH_CANCELED =>
      val r = BatchCanceled
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_INPUT =>
      val r = InvalidInput
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_S3_BUCKET =>
      val r = WrongRegionS3Bucket
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_S3_OUTPUT =>
      val r = WrongRegionS3Output
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_ROBOT_APPLICATION =>
      val r = WrongRegionRobotApplication
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_SIMULATION_APPLICATION =>
      val r = WrongRegionSimulationApplication
      r
    case software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.UPLOAD_CONTENT_MISMATCH_ERROR =>
      val r = UploadContentMismatchError
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object InternalServiceError
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INTERNAL_SERVICE_ERROR
  }
  case object RobotApplicationCrash
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ROBOT_APPLICATION_CRASH
  }
  case object SimulationApplicationCrash
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SIMULATION_APPLICATION_CRASH
  }
  case object RobotApplicationHealthCheckFailure
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ROBOT_APPLICATION_HEALTH_CHECK_FAILURE
  }
  case object SimulationApplicationHealthCheckFailure
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SIMULATION_APPLICATION_HEALTH_CHECK_FAILURE
  }
  case object BadPermissionsRobotApplication
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_ROBOT_APPLICATION
  }
  case object BadPermissionsSimulationApplication
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_SIMULATION_APPLICATION
  }
  case object BadPermissionsS3Object
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_S3_OBJECT
  }
  case object BadPermissionsS3Output
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_S3_OUTPUT
  }
  case object BadPermissionsCloudwatchLogs
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_CLOUDWATCH_LOGS
  }
  case object SubnetIpLimitExceeded
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SUBNET_IP_LIMIT_EXCEEDED
  }
  case object ENILimitExceeded
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ENI_LIMIT_EXCEEDED
  }
  case object BadPermissionsUserCredentials
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BAD_PERMISSIONS_USER_CREDENTIALS
  }
  case object InvalidBundleRobotApplication
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_BUNDLE_ROBOT_APPLICATION
  }
  case object InvalidBundleSimulationApplication
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_BUNDLE_SIMULATION_APPLICATION
  }
  case object InvalidS3Resource
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_S3_RESOURCE
  }
  case object ThrottlingError
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.THROTTLING_ERROR
  }
  case object LimitExceeded
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.LIMIT_EXCEEDED
  }
  case object MismatchedEtag
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.MISMATCHED_ETAG
  }
  case object RobotApplicationVersionMismatchedEtag
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.ROBOT_APPLICATION_VERSION_MISMATCHED_ETAG
  }
  case object SimulationApplicationVersionMismatchedEtag
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.SIMULATION_APPLICATION_VERSION_MISMATCHED_ETAG
  }
  case object ResourceNotFound
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.RESOURCE_NOT_FOUND
  }
  case object RequestThrottled
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.REQUEST_THROTTLED
  }
  case object BatchTimedOut
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BATCH_TIMED_OUT
  }
  case object BatchCanceled
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.BATCH_CANCELED
  }
  case object InvalidInput
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.INVALID_INPUT
  }
  case object WrongRegionS3Bucket
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_S3_BUCKET
  }
  case object WrongRegionS3Output
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_S3_OUTPUT
  }
  case object WrongRegionRobotApplication
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_ROBOT_APPLICATION
  }
  case object WrongRegionSimulationApplication
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.WRONG_REGION_SIMULATION_APPLICATION
  }
  case object UploadContentMismatchError
      extends zio.aws.robomaker.model.SimulationJobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode =
      software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode.UPLOAD_CONTENT_MISMATCH_ERROR
  }
}
