package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.SimulationSoftwareSuiteVersionType
import scala.jdk.CollectionConverters.*
final case class SimulationSoftwareSuite(
    name: Optional[zio.aws.robomaker.model.SimulationSoftwareSuiteType] =
      Optional.Absent,
    version: Optional[SimulationSoftwareSuiteVersionType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuite = {
    import SimulationSoftwareSuite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuite
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        version.map(value =>
          SimulationSoftwareSuiteVersionType.unwrap(value): java.lang.String
        )
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly =
    zio.aws.robomaker.model.SimulationSoftwareSuite.wrap(buildAwsValue())
}
object SimulationSoftwareSuite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SimulationSoftwareSuite =
      zio.aws.robomaker.model.SimulationSoftwareSuite(
        name.map(value => value),
        version.map(value => value)
      )
    def name: Optional[zio.aws.robomaker.model.SimulationSoftwareSuiteType]
    def version: Optional[SimulationSoftwareSuiteVersionType]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationSoftwareSuiteType
    ] = AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, SimulationSoftwareSuiteVersionType] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuite
  ) extends zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly {
    override val name
        : Optional[zio.aws.robomaker.model.SimulationSoftwareSuiteType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.robomaker.model.SimulationSoftwareSuiteType.wrap(value)
        )
    override val version: Optional[SimulationSoftwareSuiteVersionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value =>
          zio.aws.robomaker.model.primitives
            .SimulationSoftwareSuiteVersionType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationSoftwareSuite
  ): zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly = new Wrapper(
    impl
  )
}
