package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.{S3Key, S3Bucket}
import scala.jdk.CollectionConverters.*
final case class TemplateLocation(s3Bucket: S3Bucket, s3Key: S3Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.TemplateLocation = {
    import TemplateLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.TemplateLocation
      .builder()
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .s3Key(S3Key.unwrap(s3Key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.TemplateLocation.ReadOnly =
    zio.aws.robomaker.model.TemplateLocation.wrap(buildAwsValue())
}
object TemplateLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.TemplateLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.TemplateLocation =
      zio.aws.robomaker.model.TemplateLocation(s3Bucket, s3Key)
    def s3Bucket: S3Bucket
    def s3Key: S3Key
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3Key: ZIO[Any, Nothing, S3Key] = ZIO.succeed(s3Key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.TemplateLocation
  ) extends zio.aws.robomaker.model.TemplateLocation.ReadOnly {
    override val s3Bucket: S3Bucket =
      zio.aws.robomaker.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3Key: S3Key =
      zio.aws.robomaker.model.primitives.S3Key(impl.s3Key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.TemplateLocation
  ): zio.aws.robomaker.model.TemplateLocation.ReadOnly = new Wrapper(impl)
}
