package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  TemplateName,
  Arn,
  LastUpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class TemplateSummary(
    arn: Optional[Arn] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    name: Optional[TemplateName] = Optional.Absent,
    version: Optional[GenericString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.TemplateSummary = {
    import TemplateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.TemplateSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.TemplateSummary.ReadOnly =
    zio.aws.robomaker.model.TemplateSummary.wrap(buildAwsValue())
}
object TemplateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.TemplateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.TemplateSummary =
      zio.aws.robomaker.model.TemplateSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        version.map(value => value)
      )
    def arn: Optional[Arn]
    def createdAt: Optional[CreatedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def name: Optional[TemplateName]
    def version: Optional[GenericString]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.TemplateSummary
  ) extends zio.aws.robomaker.model.TemplateSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val name: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val version: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: GenericString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.TemplateSummary
  ): zio.aws.robomaker.model.TemplateSummary.ReadOnly = new Wrapper(impl)
}
