package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  RevisionId,
  Arn,
  Version,
  Name,
  LastUpdatedAt
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateRobotApplicationResponse(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.robomaker.model.Source]] =
      Optional.Absent,
    robotSoftwareSuite: Optional[zio.aws.robomaker.model.RobotSoftwareSuite] =
      Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    revisionId: Optional[RevisionId] = Optional.Absent,
    environment: Optional[zio.aws.robomaker.model.Environment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse = {
    import UpdateRobotApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(robotSoftwareSuite.map(value => value.buildAwsValue()))(
        _.robotSoftwareSuite
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly =
    zio.aws.robomaker.model.UpdateRobotApplicationResponse.wrap(buildAwsValue())
}
object UpdateRobotApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UpdateRobotApplicationResponse =
      zio.aws.robomaker.model.UpdateRobotApplicationResponse(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        robotSoftwareSuite.map(value => value.asEditable),
        lastUpdatedAt.map(value => value),
        revisionId.map(value => value),
        environment.map(value => value.asEditable)
      )
    def arn: Optional[Arn]
    def name: Optional[Name]
    def version: Optional[Version]
    def sources: Optional[List[zio.aws.robomaker.model.Source.ReadOnly]]
    def robotSoftwareSuite
        : Optional[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def revisionId: Optional[RevisionId]
    def environment: Optional[zio.aws.robomaker.model.Environment.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Source.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
    def getRobotSoftwareSuite: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = AwsError.unwrapOptionField("robotSoftwareSuite", robotSoftwareSuite)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse
  ) extends zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
    override val sources
        : Optional[List[zio.aws.robomaker.model.Source.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.Source.wrap(item)
          }.toList
        )
    override val robotSoftwareSuite
        : Optional[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.robotSoftwareSuite())
        .map(value => zio.aws.robomaker.model.RobotSoftwareSuite.wrap(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val revisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val environment
        : Optional[zio.aws.robomaker.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse
  ): zio.aws.robomaker.model.UpdateRobotApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
