package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  LastUpdatedAt,
  CreatedAt,
  TemplateName,
  Arn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class UpdateWorldTemplateResponse(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[TemplateName] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse = {
    import UpdateWorldTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly =
    zio.aws.robomaker.model.UpdateWorldTemplateResponse.wrap(buildAwsValue())
}
object UpdateWorldTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UpdateWorldTemplateResponse =
      zio.aws.robomaker.model.UpdateWorldTemplateResponse(
        arn.map(value => value),
        name.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value)
      )
    def arn: Optional[Arn]
    def name: Optional[TemplateName]
    def createdAt: Optional[CreatedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
  ) extends zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse
  ): zio.aws.robomaker.model.UpdateWorldTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
