package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait WorldExportJobStatus {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus
}
object WorldExportJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus
  ): zio.aws.robomaker.model.WorldExportJobStatus = value match {
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.CANCELING =>
      val r = Canceling
      r
    case software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.CANCELED =>
      val r = Canceled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.PENDING
  }
  case object Running extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.RUNNING
  }
  case object Completed extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.FAILED
  }
  case object Canceling extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.CANCELING
  }
  case object Canceled extends zio.aws.robomaker.model.WorldExportJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldExportJobStatus.CANCELED
  }
}
