package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{CreatedAt, Arn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class WorldSummary(
    arn: Optional[Arn] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    generationJob: Optional[Arn] = Optional.Absent,
    template: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldSummary = {
    import WorldSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        generationJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.generationJob)
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldSummary.ReadOnly =
    zio.aws.robomaker.model.WorldSummary.wrap(buildAwsValue())
}
object WorldSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldSummary =
      zio.aws.robomaker.model.WorldSummary(
        arn.map(value => value),
        createdAt.map(value => value),
        generationJob.map(value => value),
        template.map(value => value)
      )
    def arn: Optional[Arn]
    def createdAt: Optional[CreatedAt]
    def generationJob: Optional[Arn]
    def template: Optional[Arn]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getGenerationJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("generationJob", generationJob)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldSummary
  ) extends zio.aws.robomaker.model.WorldSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val generationJob: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.generationJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val template: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldSummary
  ): zio.aws.robomaker.model.WorldSummary.ReadOnly = new Wrapper(impl)
}
