package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait ComputeType {
  def unwrap: software.amazon.awssdk.services.robomaker.model.ComputeType
}
object ComputeType {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.ComputeType
  ): zio.aws.robomaker.model.ComputeType = value match {
    case software.amazon.awssdk.services.robomaker.model.ComputeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.ComputeType.CPU =>
      val r = CPU
      r
    case software.amazon.awssdk.services.robomaker.model.ComputeType.GPU_AND_CPU =>
      val r = GPU_AND_CPU
      r
  }
  case object unknownToSdkVersion extends zio.aws.robomaker.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.ComputeType =
      software.amazon.awssdk.services.robomaker.model.ComputeType.UNKNOWN_TO_SDK_VERSION
  }
  case object CPU extends zio.aws.robomaker.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.ComputeType =
      software.amazon.awssdk.services.robomaker.model.ComputeType.CPU
  }
  case object GPU_AND_CPU extends zio.aws.robomaker.model.ComputeType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.ComputeType =
      software.amazon.awssdk.services.robomaker.model.ComputeType.GPU_AND_CPU
  }
}
