package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{
  IamRole,
  ClientRequestToken,
  TagValue,
  JobDuration,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateSimulationJobRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    outputLocation: Optional[zio.aws.robomaker.model.OutputLocation] =
      Optional.Absent,
    loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig] =
      Optional.Absent,
    maxJobDurationInSeconds: JobDuration,
    iamRole: IamRole,
    failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior] =
      Optional.Absent,
    robotApplications: Optional[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = Optional.Absent,
    simulationApplications: Optional[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = Optional.Absent,
    dataSources: Optional[Iterable[zio.aws.robomaker.model.DataSourceConfig]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    vpcConfig: Optional[zio.aws.robomaker.model.VPCConfig] = Optional.Absent,
    compute: Optional[zio.aws.robomaker.model.Compute] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest = {
    import CreateSimulationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .maxJobDurationInSeconds(
        JobDuration.unwrap(maxJobDurationInSeconds): java.lang.Long
      )
      .iamRole(IamRole.unwrap(iamRole): java.lang.String)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.CreateSimulationJobRequest.ReadOnly =
    zio.aws.robomaker.model.CreateSimulationJobRequest.wrap(buildAwsValue())
}
object CreateSimulationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CreateSimulationJobRequest =
      zio.aws.robomaker.model.CreateSimulationJobRequest(
        clientRequestToken.map(value => value),
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds,
        iamRole,
        failureBehavior.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        vpcConfig.map(value => value.asEditable),
        compute.map(value => value.asEditable)
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: JobDuration
    def iamRole: IamRole
    def failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior]
    def robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ]
    def simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources
        : Optional[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def vpcConfig: Optional[zio.aws.robomaker.model.VPCConfig.ReadOnly]
    def compute: Optional[zio.aws.robomaker.model.Compute.ReadOnly]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, Nothing, JobDuration] =
      ZIO.succeed(maxJobDurationInSeconds)
    def getIamRole: ZIO[Any, Nothing, IamRole] = ZIO.succeed(iamRole)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Compute.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
  ) extends zio.aws.robomaker.model.CreateSimulationJobRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: JobDuration =
      zio.aws.robomaker.model.primitives
        .JobDuration(impl.maxJobDurationInSeconds())
    override val iamRole: IamRole =
      zio.aws.robomaker.model.primitives.IamRole(impl.iamRole())
    override val failureBehavior
        : Optional[zio.aws.robomaker.model.FailureBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureBehavior())
        .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Optional[List[zio.aws.robomaker.model.DataSourceConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.DataSourceConfig.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcConfig
        : Optional[zio.aws.robomaker.model.VPCConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.robomaker.model.VPCConfig.wrap(value))
    override val compute: Optional[zio.aws.robomaker.model.Compute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compute())
        .map(value => zio.aws.robomaker.model.Compute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest
  ): zio.aws.robomaker.model.CreateSimulationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
