package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait RobotSoftwareSuiteVersionType {
  def unwrap: software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType
}
object RobotSoftwareSuiteVersionType {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType
  ): zio.aws.robomaker.model.RobotSoftwareSuiteVersionType = value match {
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.KINETIC =>
      val r = Kinetic
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.MELODIC =>
      val r = Melodic
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.DASHING =>
      val r = Dashing
      r
    case software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.FOXY =>
      val r = Foxy
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.RobotSoftwareSuiteVersionType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.UNKNOWN_TO_SDK_VERSION
  }
  case object Kinetic
      extends zio.aws.robomaker.model.RobotSoftwareSuiteVersionType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.KINETIC
  }
  case object Melodic
      extends zio.aws.robomaker.model.RobotSoftwareSuiteVersionType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.MELODIC
  }
  case object Dashing
      extends zio.aws.robomaker.model.RobotSoftwareSuiteVersionType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.DASHING
  }
  case object Foxy
      extends zio.aws.robomaker.model.RobotSoftwareSuiteVersionType {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType =
      software.amazon.awssdk.services.robomaker.model.RobotSoftwareSuiteVersionType.FOXY
  }
}
