package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{DeploymentTimeout, Percentage}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DeploymentConfig(
    concurrentDeploymentPercentage: Optional[Percentage] = Optional.Absent,
    failureThresholdPercentage: Optional[Percentage] = Optional.Absent,
    robotDeploymentTimeoutInSeconds: Optional[DeploymentTimeout] =
      Optional.Absent,
    downloadConditionFile: Optional[zio.aws.robomaker.model.S3Object] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeploymentConfig = {
    import DeploymentConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeploymentConfig
      .builder()
      .optionallyWith(
        concurrentDeploymentPercentage.map(value =>
          Percentage.unwrap(value): Integer
        )
      )(_.concurrentDeploymentPercentage)
      .optionallyWith(
        failureThresholdPercentage.map(value =>
          Percentage.unwrap(value): Integer
        )
      )(_.failureThresholdPercentage)
      .optionallyWith(
        robotDeploymentTimeoutInSeconds.map(value =>
          DeploymentTimeout.unwrap(value): java.lang.Long
        )
      )(_.robotDeploymentTimeoutInSeconds)
      .optionallyWith(
        downloadConditionFile.map(value => value.buildAwsValue())
      )(_.downloadConditionFile)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeploymentConfig.ReadOnly =
    zio.aws.robomaker.model.DeploymentConfig.wrap(buildAwsValue())
}
object DeploymentConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeploymentConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeploymentConfig =
      zio.aws.robomaker.model.DeploymentConfig(
        concurrentDeploymentPercentage.map(value => value),
        failureThresholdPercentage.map(value => value),
        robotDeploymentTimeoutInSeconds.map(value => value),
        downloadConditionFile.map(value => value.asEditable)
      )
    def concurrentDeploymentPercentage: Optional[Percentage]
    def failureThresholdPercentage: Optional[Percentage]
    def robotDeploymentTimeoutInSeconds: Optional[DeploymentTimeout]
    def downloadConditionFile
        : Optional[zio.aws.robomaker.model.S3Object.ReadOnly]
    def getConcurrentDeploymentPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField(
        "concurrentDeploymentPercentage",
        concurrentDeploymentPercentage
      )
    def getFailureThresholdPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField(
        "failureThresholdPercentage",
        failureThresholdPercentage
      )
    def getRobotDeploymentTimeoutInSeconds
        : ZIO[Any, AwsError, DeploymentTimeout] = AwsError.unwrapOptionField(
      "robotDeploymentTimeoutInSeconds",
      robotDeploymentTimeoutInSeconds
    )
    def getDownloadConditionFile
        : ZIO[Any, AwsError, zio.aws.robomaker.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("downloadConditionFile", downloadConditionFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentConfig
  ) extends zio.aws.robomaker.model.DeploymentConfig.ReadOnly {
    override val concurrentDeploymentPercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.concurrentDeploymentPercentage())
        .map(value => zio.aws.robomaker.model.primitives.Percentage(value))
    override val failureThresholdPercentage: Optional[Percentage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureThresholdPercentage())
        .map(value => zio.aws.robomaker.model.primitives.Percentage(value))
    override val robotDeploymentTimeoutInSeconds: Optional[DeploymentTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.robotDeploymentTimeoutInSeconds())
        .map(value =>
          zio.aws.robomaker.model.primitives.DeploymentTimeout(value)
        )
    override val downloadConditionFile
        : Optional[zio.aws.robomaker.model.S3Object.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downloadConditionFile())
        .map(value => zio.aws.robomaker.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeploymentConfig
  ): zio.aws.robomaker.model.DeploymentConfig.ReadOnly = new Wrapper(impl)
}
