package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{Version, Arn}
import scala.jdk.CollectionConverters.*
final case class DescribeRobotApplicationRequest(
    application: Arn,
    applicationVersion: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest = {
    import DescribeRobotApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        applicationVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.applicationVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeRobotApplicationRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeRobotApplicationRequest
      .wrap(buildAwsValue())
}
object DescribeRobotApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeRobotApplicationRequest =
      zio.aws.robomaker.model.DescribeRobotApplicationRequest(
        application,
        applicationVersion.map(value => value)
      )
    def application: Arn
    def applicationVersion: Optional[Version]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getApplicationVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("applicationVersion", applicationVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest
  ) extends zio.aws.robomaker.model.DescribeRobotApplicationRequest.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val applicationVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationVersion())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest
  ): zio.aws.robomaker.model.DescribeRobotApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
