package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class FailureSummary(
    totalFailureCount: Optional[Integer] = Optional.Absent,
    failures: Optional[Iterable[zio.aws.robomaker.model.WorldFailure]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.FailureSummary = {
    import FailureSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.FailureSummary
      .builder()
      .optionallyWith(totalFailureCount.map(value => value: java.lang.Integer))(
        _.totalFailureCount
      )
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.FailureSummary.ReadOnly =
    zio.aws.robomaker.model.FailureSummary.wrap(buildAwsValue())
}
object FailureSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.FailureSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.FailureSummary =
      zio.aws.robomaker.model.FailureSummary(
        totalFailureCount.map(value => value),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def totalFailureCount: Optional[Integer]
    def failures: Optional[List[zio.aws.robomaker.model.WorldFailure.ReadOnly]]
    def getTotalFailureCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalFailureCount", totalFailureCount)
    def getFailures: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.WorldFailure.ReadOnly
    ]] = AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.FailureSummary
  ) extends zio.aws.robomaker.model.FailureSummary.ReadOnly {
    override val totalFailureCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalFailureCount())
      .map(value => value: Integer)
    override val failures
        : Optional[List[zio.aws.robomaker.model.WorldFailure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.WorldFailure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.FailureSummary
  ): zio.aws.robomaker.model.FailureSummary.ReadOnly = new Wrapper(impl)
}
