package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.Json
import scala.jdk.CollectionConverters.*
final case class GetWorldTemplateBodyResponse(
    templateBody: Optional[Json] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse = {
    import GetWorldTemplateBodyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse
      .builder()
      .optionallyWith(
        templateBody.map(value => Json.unwrap(value): java.lang.String)
      )(_.templateBody)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly =
    zio.aws.robomaker.model.GetWorldTemplateBodyResponse.wrap(buildAwsValue())
}
object GetWorldTemplateBodyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.GetWorldTemplateBodyResponse =
      zio.aws.robomaker.model
        .GetWorldTemplateBodyResponse(templateBody.map(value => value))
    def templateBody: Optional[Json]
    def getTemplateBody: ZIO[Any, AwsError, Json] =
      AwsError.unwrapOptionField("templateBody", templateBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse
  ) extends zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly {
    override val templateBody: Optional[Json] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.robomaker.model.primitives.Json(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse
  ): zio.aws.robomaker.model.GetWorldTemplateBodyResponse.ReadOnly =
    new Wrapper(impl)
}
