package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{S3Key, S3Bucket}
import scala.jdk.CollectionConverters.*
final case class OutputLocation(
    s3Bucket: Optional[S3Bucket] = Optional.Absent,
    s3Prefix: Optional[S3Key] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.OutputLocation = {
    import OutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.OutputLocation
      .builder()
      .optionallyWith(
        s3Bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Prefix.map(value => S3Key.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.OutputLocation.ReadOnly =
    zio.aws.robomaker.model.OutputLocation.wrap(buildAwsValue())
}
object OutputLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.OutputLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.OutputLocation =
      zio.aws.robomaker.model.OutputLocation(
        s3Bucket.map(value => value),
        s3Prefix.map(value => value)
      )
    def s3Bucket: Optional[S3Bucket]
    def s3Prefix: Optional[S3Key]
    def getS3Bucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.OutputLocation
  ) extends zio.aws.robomaker.model.OutputLocation.ReadOnly {
    override val s3Bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value => zio.aws.robomaker.model.primitives.S3Bucket(value))
    override val s3Prefix: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Prefix())
      .map(value => zio.aws.robomaker.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.OutputLocation
  ): zio.aws.robomaker.model.OutputLocation.ReadOnly = new Wrapper(impl)
}
