package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{LastUpdatedAt, Version, Arn, Name}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class RobotApplicationSummary(
    name: Optional[Name] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    robotSoftwareSuite: Optional[zio.aws.robomaker.model.RobotSoftwareSuite] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary = {
    import RobotApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(robotSoftwareSuite.map(value => value.buildAwsValue()))(
        _.robotSoftwareSuite
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly =
    zio.aws.robomaker.model.RobotApplicationSummary.wrap(buildAwsValue())
}
object RobotApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.RobotApplicationSummary =
      zio.aws.robomaker.model.RobotApplicationSummary(
        name.map(value => value),
        arn.map(value => value),
        version.map(value => value),
        lastUpdatedAt.map(value => value),
        robotSoftwareSuite.map(value => value.asEditable)
      )
    def name: Optional[Name]
    def arn: Optional[Arn]
    def version: Optional[Version]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def robotSoftwareSuite
        : Optional[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRobotSoftwareSuite: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = AwsError.unwrapOptionField("robotSoftwareSuite", robotSoftwareSuite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
  ) extends zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly {
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.robomaker.model.primitives.Version(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val robotSoftwareSuite
        : Optional[zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.robotSoftwareSuite())
        .map(value => zio.aws.robomaker.model.RobotSoftwareSuite.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.RobotApplicationSummary
  ): zio.aws.robomaker.model.RobotApplicationSummary.ReadOnly = new Wrapper(
    impl
  )
}
