package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  Integer,
  CreatedAt,
  LastUpdatedAt,
  Arn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class SimulationJobBatchSummary(
    arn: Optional[Arn] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.SimulationJobBatchStatus] =
      Optional.Absent,
    failedRequestCount: Optional[Integer] = Optional.Absent,
    pendingRequestCount: Optional[Integer] = Optional.Absent,
    createdRequestCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary = {
    import SimulationJobBatchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failedRequestCount.map(value => value: java.lang.Integer)
      )(_.failedRequestCount)
      .optionallyWith(
        pendingRequestCount.map(value => value: java.lang.Integer)
      )(_.pendingRequestCount)
      .optionallyWith(
        createdRequestCount.map(value => value: java.lang.Integer)
      )(_.createdRequestCount)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly =
    zio.aws.robomaker.model.SimulationJobBatchSummary.wrap(buildAwsValue())
}
object SimulationJobBatchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.SimulationJobBatchSummary =
      zio.aws.robomaker.model.SimulationJobBatchSummary(
        arn.map(value => value),
        lastUpdatedAt.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        failedRequestCount.map(value => value),
        pendingRequestCount.map(value => value),
        createdRequestCount.map(value => value)
      )
    def arn: Optional[Arn]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def createdAt: Optional[CreatedAt]
    def status: Optional[zio.aws.robomaker.model.SimulationJobBatchStatus]
    def failedRequestCount: Optional[Integer]
    def pendingRequestCount: Optional[Integer]
    def createdRequestCount: Optional[Integer]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobBatchStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFailedRequestCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedRequestCount", failedRequestCount)
    def getPendingRequestCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingRequestCount", pendingRequestCount)
    def getCreatedRequestCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("createdRequestCount", createdRequestCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary
  ) extends zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val status
        : Optional[zio.aws.robomaker.model.SimulationJobBatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.robomaker.model.SimulationJobBatchStatus.wrap(value)
        )
    override val failedRequestCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedRequestCount())
      .map(value => value: Integer)
    override val pendingRequestCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingRequestCount())
      .map(value => value: Integer)
    override val createdRequestCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.createdRequestCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary
  ): zio.aws.robomaker.model.SimulationJobBatchSummary.ReadOnly = new Wrapper(
    impl
  )
}
