package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{Json, TemplateName, Arn}
import scala.jdk.CollectionConverters.*
final case class UpdateWorldTemplateRequest(
    template: Arn,
    name: Optional[TemplateName] = Optional.Absent,
    templateBody: Optional[Json] = Optional.Absent,
    templateLocation: Optional[zio.aws.robomaker.model.TemplateLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest = {
    import UpdateWorldTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest
      .builder()
      .template(Arn.unwrap(template): java.lang.String)
      .optionallyWith(
        name.map(value => TemplateName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        templateBody.map(value => Json.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(templateLocation.map(value => value.buildAwsValue()))(
        _.templateLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.UpdateWorldTemplateRequest.ReadOnly =
    zio.aws.robomaker.model.UpdateWorldTemplateRequest.wrap(buildAwsValue())
}
object UpdateWorldTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UpdateWorldTemplateRequest =
      zio.aws.robomaker.model.UpdateWorldTemplateRequest(
        template,
        name.map(value => value),
        templateBody.map(value => value),
        templateLocation.map(value => value.asEditable)
      )
    def template: Arn
    def name: Optional[TemplateName]
    def templateBody: Optional[Json]
    def templateLocation
        : Optional[zio.aws.robomaker.model.TemplateLocation.ReadOnly]
    def getTemplate: ZIO[Any, Nothing, Arn] = ZIO.succeed(template)
    def getName: ZIO[Any, AwsError, TemplateName] =
      AwsError.unwrapOptionField("name", name)
    def getTemplateBody: ZIO[Any, AwsError, Json] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateLocation: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.TemplateLocation.ReadOnly
    ] = AwsError.unwrapOptionField("templateLocation", templateLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest
  ) extends zio.aws.robomaker.model.UpdateWorldTemplateRequest.ReadOnly {
    override val template: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.template())
    override val name: Optional[TemplateName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.TemplateName(value))
    override val templateBody: Optional[Json] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.robomaker.model.primitives.Json(value))
    override val templateLocation
        : Optional[zio.aws.robomaker.model.TemplateLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateLocation())
        .map(value => zio.aws.robomaker.model.TemplateLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest
  ): zio.aws.robomaker.model.UpdateWorldTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
