package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{Integer, CreatedAt, Arn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class WorldGenerationJobSummary(
    arn: Optional[Arn] = Optional.Absent,
    template: Optional[Arn] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.WorldGenerationJobStatus] =
      Optional.Absent,
    worldCount: Optional[zio.aws.robomaker.model.WorldCount] = Optional.Absent,
    succeededWorldCount: Optional[Integer] = Optional.Absent,
    failedWorldCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary = {
    import WorldGenerationJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        template.map(value => Arn.unwrap(value): java.lang.String)
      )(_.template)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(worldCount.map(value => value.buildAwsValue()))(
        _.worldCount
      )
      .optionallyWith(
        succeededWorldCount.map(value => value: java.lang.Integer)
      )(_.succeededWorldCount)
      .optionallyWith(failedWorldCount.map(value => value: java.lang.Integer))(
        _.failedWorldCount
      )
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly =
    zio.aws.robomaker.model.WorldGenerationJobSummary.wrap(buildAwsValue())
}
object WorldGenerationJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.WorldGenerationJobSummary =
      zio.aws.robomaker.model.WorldGenerationJobSummary(
        arn.map(value => value),
        template.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        worldCount.map(value => value.asEditable),
        succeededWorldCount.map(value => value),
        failedWorldCount.map(value => value)
      )
    def arn: Optional[Arn]
    def template: Optional[Arn]
    def createdAt: Optional[CreatedAt]
    def status: Optional[zio.aws.robomaker.model.WorldGenerationJobStatus]
    def worldCount: Optional[zio.aws.robomaker.model.WorldCount.ReadOnly]
    def succeededWorldCount: Optional[Integer]
    def failedWorldCount: Optional[Integer]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getTemplate: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("template", template)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldGenerationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getWorldCount
        : ZIO[Any, AwsError, zio.aws.robomaker.model.WorldCount.ReadOnly] =
      AwsError.unwrapOptionField("worldCount", worldCount)
    def getSucceededWorldCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("succeededWorldCount", succeededWorldCount)
    def getFailedWorldCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedWorldCount", failedWorldCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
  ) extends zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val template: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.template())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val status
        : Optional[zio.aws.robomaker.model.WorldGenerationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.robomaker.model.WorldGenerationJobStatus.wrap(value)
        )
    override val worldCount
        : Optional[zio.aws.robomaker.model.WorldCount.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.worldCount())
        .map(value => zio.aws.robomaker.model.WorldCount.wrap(value))
    override val succeededWorldCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.succeededWorldCount())
      .map(value => value: Integer)
    override val failedWorldCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedWorldCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobSummary
  ): zio.aws.robomaker.model.WorldGenerationJobSummary.ReadOnly = new Wrapper(
    impl
  )
}
