package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CancelWorldGenerationJobRequest(job: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest = {
    import CancelWorldGenerationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest
      .builder()
      .job(Arn.unwrap(job): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CancelWorldGenerationJobRequest.ReadOnly =
    zio.aws.robomaker.model.CancelWorldGenerationJobRequest
      .wrap(buildAwsValue())
}
object CancelWorldGenerationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.CancelWorldGenerationJobRequest =
      zio.aws.robomaker.model.CancelWorldGenerationJobRequest(job)
    def job: Arn
    def getJob: ZIO[Any, Nothing, Arn] = ZIO.succeed(job)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest
  ) extends zio.aws.robomaker.model.CancelWorldGenerationJobRequest.ReadOnly {
    override val job: Arn = zio.aws.robomaker.model.primitives.Arn(impl.job())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest
  ): zio.aws.robomaker.model.CancelWorldGenerationJobRequest.ReadOnly =
    new Wrapper(impl)
}
