package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{ImageDigest, S3Etag, RevisionId, Arn}
import scala.jdk.CollectionConverters.*
final case class CreateRobotApplicationVersionRequest(
    application: Arn,
    currentRevisionId: Optional[RevisionId] = Optional.Absent,
    s3Etags: Optional[Iterable[S3Etag]] = Optional.Absent,
    imageDigest: Optional[ImageDigest] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest = {
    import CreateRobotApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        currentRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.currentRevisionId)
      .optionallyWith(
        s3Etags.map(value =>
          value.map { item =>
            S3Etag.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.s3Etags)
      .optionallyWith(
        imageDigest.map(value => ImageDigest.unwrap(value): java.lang.String)
      )(_.imageDigest)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.CreateRobotApplicationVersionRequest.ReadOnly =
    zio.aws.robomaker.model.CreateRobotApplicationVersionRequest
      .wrap(buildAwsValue())
}
object CreateRobotApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.robomaker.model.CreateRobotApplicationVersionRequest =
      zio.aws.robomaker.model.CreateRobotApplicationVersionRequest(
        application,
        currentRevisionId.map(value => value),
        s3Etags.map(value => value),
        imageDigest.map(value => value)
      )
    def application: Arn
    def currentRevisionId: Optional[RevisionId]
    def s3Etags: Optional[List[S3Etag]]
    def imageDigest: Optional[ImageDigest]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getCurrentRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("currentRevisionId", currentRevisionId)
    def getS3Etags: ZIO[Any, AwsError, List[S3Etag]] =
      AwsError.unwrapOptionField("s3Etags", s3Etags)
    def getImageDigest: ZIO[Any, AwsError, ImageDigest] =
      AwsError.unwrapOptionField("imageDigest", imageDigest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest
  ) extends zio.aws.robomaker.model.CreateRobotApplicationVersionRequest.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val currentRevisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.currentRevisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val s3Etags: Optional[List[S3Etag]] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Etags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.primitives.S3Etag(item)
        }.toList
      )
    override val imageDigest: Optional[ImageDigest] = zio.aws.core.internal
      .optionalFromNullable(impl.imageDigest())
      .map(value => zio.aws.robomaker.model.primitives.ImageDigest(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest
  ): zio.aws.robomaker.model.CreateRobotApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
