package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteWorldTemplateRequest(template: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest = {
    import DeleteWorldTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest
      .builder()
      .template(Arn.unwrap(template): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.DeleteWorldTemplateRequest.ReadOnly =
    zio.aws.robomaker.model.DeleteWorldTemplateRequest.wrap(buildAwsValue())
}
object DeleteWorldTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DeleteWorldTemplateRequest =
      zio.aws.robomaker.model.DeleteWorldTemplateRequest(template)
    def template: Arn
    def getTemplate: ZIO[Any, Nothing, Arn] = ZIO.succeed(template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest
  ) extends zio.aws.robomaker.model.DeleteWorldTemplateRequest.ReadOnly {
    override val template: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.template())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest
  ): zio.aws.robomaker.model.DeleteWorldTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
