package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentStatus {
  def unwrap: software.amazon.awssdk.services.robomaker.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.DeploymentStatus
  ): zio.aws.robomaker.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.PREPARING =>
      val r = Preparing
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.robomaker.model.DeploymentStatus.CANCELED =>
      val r = Canceled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.PENDING
  }
  case object Preparing extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.PREPARING
  }
  case object InProgress extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.IN_PROGRESS
  }
  case object Failed extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.FAILED
  }
  case object Succeeded extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.SUCCEEDED
  }
  case object Canceled extends zio.aws.robomaker.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.DeploymentStatus =
      software.amazon.awssdk.services.robomaker.model.DeploymentStatus.CANCELED
  }
}
