package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DescribeSimulationJobBatchRequest(batch: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest = {
    import DescribeSimulationJobBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest
      .builder()
      .batch(Arn.unwrap(batch): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeSimulationJobBatchRequest.ReadOnly =
    zio.aws.robomaker.model.DescribeSimulationJobBatchRequest
      .wrap(buildAwsValue())
}
object DescribeSimulationJobBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeSimulationJobBatchRequest =
      zio.aws.robomaker.model.DescribeSimulationJobBatchRequest(batch)
    def batch: Arn
    def getBatch: ZIO[Any, Nothing, Arn] = ZIO.succeed(batch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest
  ) extends zio.aws.robomaker.model.DescribeSimulationJobBatchRequest.ReadOnly {
    override val batch: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.batch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest
  ): zio.aws.robomaker.model.DescribeSimulationJobBatchRequest.ReadOnly =
    new Wrapper(impl)
}
