package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  IamRole,
  GenericString,
  ClientRequestToken,
  TagValue,
  SimulationTimeMillis,
  LastStartedAt,
  Arn,
  JobDuration,
  Name,
  LastUpdatedAt,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeSimulationJobResponse(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.SimulationJobStatus] =
      Optional.Absent,
    lastStartedAt: Optional[LastStartedAt] = Optional.Absent,
    lastUpdatedAt: Optional[LastUpdatedAt] = Optional.Absent,
    failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior] =
      Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.SimulationJobErrorCode] =
      Optional.Absent,
    failureReason: Optional[GenericString] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    outputLocation: Optional[zio.aws.robomaker.model.OutputLocation] =
      Optional.Absent,
    loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig] =
      Optional.Absent,
    maxJobDurationInSeconds: Optional[JobDuration] = Optional.Absent,
    simulationTimeMillis: Optional[SimulationTimeMillis] = Optional.Absent,
    iamRole: Optional[IamRole] = Optional.Absent,
    robotApplications: Optional[
      Iterable[zio.aws.robomaker.model.RobotApplicationConfig]
    ] = Optional.Absent,
    simulationApplications: Optional[
      Iterable[zio.aws.robomaker.model.SimulationApplicationConfig]
    ] = Optional.Absent,
    dataSources: Optional[Iterable[zio.aws.robomaker.model.DataSource]] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    vpcConfig: Optional[zio.aws.robomaker.model.VPCConfigResponse] =
      Optional.Absent,
    networkInterface: Optional[zio.aws.robomaker.model.NetworkInterface] =
      Optional.Absent,
    compute: Optional[zio.aws.robomaker.model.ComputeResponse] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse = {
    import DescribeSimulationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastStartedAt.map(value => LastStartedAt.unwrap(value): Instant)
      )(_.lastStartedAt)
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdatedAt.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(failureBehavior.map(value => value.unwrap))(
        _.failureBehavior
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(outputLocation.map(value => value.buildAwsValue()))(
        _.outputLocation
      )
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .optionallyWith(
        maxJobDurationInSeconds.map(value =>
          JobDuration.unwrap(value): java.lang.Long
        )
      )(_.maxJobDurationInSeconds)
      .optionallyWith(
        simulationTimeMillis.map(value =>
          SimulationTimeMillis.unwrap(value): java.lang.Long
        )
      )(_.simulationTimeMillis)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        robotApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.robotApplications)
      .optionallyWith(
        simulationApplications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.simulationApplications)
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(networkInterface.map(value => value.buildAwsValue()))(
        _.networkInterface
      )
      .optionallyWith(compute.map(value => value.buildAwsValue()))(_.compute)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly =
    zio.aws.robomaker.model.DescribeSimulationJobResponse.wrap(buildAwsValue())
}
object DescribeSimulationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.DescribeSimulationJobResponse =
      zio.aws.robomaker.model.DescribeSimulationJobResponse(
        arn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        lastStartedAt.map(value => value),
        lastUpdatedAt.map(value => value),
        failureBehavior.map(value => value),
        failureCode.map(value => value),
        failureReason.map(value => value),
        clientRequestToken.map(value => value),
        outputLocation.map(value => value.asEditable),
        loggingConfig.map(value => value.asEditable),
        maxJobDurationInSeconds.map(value => value),
        simulationTimeMillis.map(value => value),
        iamRole.map(value => value),
        robotApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationApplications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value),
        vpcConfig.map(value => value.asEditable),
        networkInterface.map(value => value.asEditable),
        compute.map(value => value.asEditable)
      )
    def arn: Optional[Arn]
    def name: Optional[Name]
    def status: Optional[zio.aws.robomaker.model.SimulationJobStatus]
    def lastStartedAt: Optional[LastStartedAt]
    def lastUpdatedAt: Optional[LastUpdatedAt]
    def failureBehavior: Optional[zio.aws.robomaker.model.FailureBehavior]
    def failureCode: Optional[zio.aws.robomaker.model.SimulationJobErrorCode]
    def failureReason: Optional[GenericString]
    def clientRequestToken: Optional[ClientRequestToken]
    def outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly]
    def loggingConfig: Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly]
    def maxJobDurationInSeconds: Optional[JobDuration]
    def simulationTimeMillis: Optional[SimulationTimeMillis]
    def iamRole: Optional[IamRole]
    def robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ]
    def simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ]
    def dataSources: Optional[List[zio.aws.robomaker.model.DataSource.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def vpcConfig: Optional[zio.aws.robomaker.model.VPCConfigResponse.ReadOnly]
    def networkInterface
        : Optional[zio.aws.robomaker.model.NetworkInterface.ReadOnly]
    def compute: Optional[zio.aws.robomaker.model.ComputeResponse.ReadOnly]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLastStartedAt: ZIO[Any, AwsError, LastStartedAt] =
      AwsError.unwrapOptionField("lastStartedAt", lastStartedAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdatedAt] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getFailureBehavior
        : ZIO[Any, AwsError, zio.aws.robomaker.model.FailureBehavior] =
      AwsError.unwrapOptionField("failureBehavior", failureBehavior)
    def getFailureCode
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobErrorCode] =
      AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getOutputLocation
        : ZIO[Any, AwsError, zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
    def getMaxJobDurationInSeconds: ZIO[Any, AwsError, JobDuration] = AwsError
      .unwrapOptionField("maxJobDurationInSeconds", maxJobDurationInSeconds)
    def getSimulationTimeMillis: ZIO[Any, AwsError, SimulationTimeMillis] =
      AwsError.unwrapOptionField("simulationTimeMillis", simulationTimeMillis)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRobotApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("robotApplications", robotApplications)
    def getSimulationApplications: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "simulationApplications",
      simulationApplications
    )
    def getDataSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.DataSource.ReadOnly
    ]] = AwsError.unwrapOptionField("dataSources", dataSources)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.VPCConfigResponse.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getNetworkInterface: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.NetworkInterface.ReadOnly
    ] = AwsError.unwrapOptionField("networkInterface", networkInterface)
    def getCompute
        : ZIO[Any, AwsError, zio.aws.robomaker.model.ComputeResponse.ReadOnly] =
      AwsError.unwrapOptionField("compute", compute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
  ) extends zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val status: Optional[zio.aws.robomaker.model.SimulationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.robomaker.model.SimulationJobStatus.wrap(value))
    override val lastStartedAt: Optional[LastStartedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStartedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastStartedAt(value))
    override val lastUpdatedAt: Optional[LastUpdatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.robomaker.model.primitives.LastUpdatedAt(value))
    override val failureBehavior
        : Optional[zio.aws.robomaker.model.FailureBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureBehavior())
        .map(value => zio.aws.robomaker.model.FailureBehavior.wrap(value))
    override val failureCode
        : Optional[zio.aws.robomaker.model.SimulationJobErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.SimulationJobErrorCode.wrap(value)
        )
    override val failureReason: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: GenericString)
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val outputLocation
        : Optional[zio.aws.robomaker.model.OutputLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputLocation())
        .map(value => zio.aws.robomaker.model.OutputLocation.wrap(value))
    override val loggingConfig
        : Optional[zio.aws.robomaker.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.robomaker.model.LoggingConfig.wrap(value))
    override val maxJobDurationInSeconds: Optional[JobDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxJobDurationInSeconds())
        .map(value => zio.aws.robomaker.model.primitives.JobDuration(value))
    override val simulationTimeMillis: Optional[SimulationTimeMillis] =
      zio.aws.core.internal
        .optionalFromNullable(impl.simulationTimeMillis())
        .map(value =>
          zio.aws.robomaker.model.primitives.SimulationTimeMillis(value)
        )
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.robomaker.model.primitives.IamRole(value))
    override val robotApplications: Optional[
      List[zio.aws.robomaker.model.RobotApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.robotApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.RobotApplicationConfig.wrap(item)
        }.toList
      )
    override val simulationApplications: Optional[
      List[zio.aws.robomaker.model.SimulationApplicationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.simulationApplications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationApplicationConfig.wrap(item)
        }.toList
      )
    override val dataSources
        : Optional[List[zio.aws.robomaker.model.DataSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.DataSource.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val vpcConfig
        : Optional[zio.aws.robomaker.model.VPCConfigResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.robomaker.model.VPCConfigResponse.wrap(value))
    override val networkInterface
        : Optional[zio.aws.robomaker.model.NetworkInterface.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterface())
        .map(value => zio.aws.robomaker.model.NetworkInterface.wrap(value))
    override val compute
        : Optional[zio.aws.robomaker.model.ComputeResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compute())
        .map(value => zio.aws.robomaker.model.ComputeResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse
  ): zio.aws.robomaker.model.DescribeSimulationJobResponse.ReadOnly =
    new Wrapper(impl)
}
