package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait ExitBehavior {
  def unwrap: software.amazon.awssdk.services.robomaker.model.ExitBehavior
}
object ExitBehavior {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.ExitBehavior
  ): zio.aws.robomaker.model.ExitBehavior = value match {
    case software.amazon.awssdk.services.robomaker.model.ExitBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.ExitBehavior.FAIL =>
      val r = FAIL
      r
    case software.amazon.awssdk.services.robomaker.model.ExitBehavior.RESTART =>
      val r = RESTART
      r
  }
  case object unknownToSdkVersion extends zio.aws.robomaker.model.ExitBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.ExitBehavior =
      software.amazon.awssdk.services.robomaker.model.ExitBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object FAIL extends zio.aws.robomaker.model.ExitBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.ExitBehavior =
      software.amazon.awssdk.services.robomaker.model.ExitBehavior.FAIL
  }
  case object RESTART extends zio.aws.robomaker.model.ExitBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.ExitBehavior =
      software.amazon.awssdk.services.robomaker.model.ExitBehavior.RESTART
  }
}
