package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait FailureBehavior {
  def unwrap: software.amazon.awssdk.services.robomaker.model.FailureBehavior
}
object FailureBehavior {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.FailureBehavior
  ): zio.aws.robomaker.model.FailureBehavior = value match {
    case software.amazon.awssdk.services.robomaker.model.FailureBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.FailureBehavior.FAIL =>
      val r = Fail
      r
    case software.amazon.awssdk.services.robomaker.model.FailureBehavior.CONTINUE =>
      val r = Continue
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.FailureBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.FailureBehavior =
      software.amazon.awssdk.services.robomaker.model.FailureBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object Fail extends zio.aws.robomaker.model.FailureBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.FailureBehavior =
      software.amazon.awssdk.services.robomaker.model.FailureBehavior.FAIL
  }
  case object Continue extends zio.aws.robomaker.model.FailureBehavior {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.FailureBehavior =
      software.amazon.awssdk.services.robomaker.model.FailureBehavior.CONTINUE
  }
}
