package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{MaxResults, PaginationToken}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSimulationJobsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.robomaker.model.Filter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest = {
    import ListSimulationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.ListSimulationJobsRequest.ReadOnly =
    zio.aws.robomaker.model.ListSimulationJobsRequest.wrap(buildAwsValue())
}
object ListSimulationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.ListSimulationJobsRequest =
      zio.aws.robomaker.model.ListSimulationJobsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def filters: Optional[List[zio.aws.robomaker.model.Filter.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.robomaker.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest
  ) extends zio.aws.robomaker.model.ListSimulationJobsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.robomaker.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.robomaker.model.primitives.MaxResults(value))
    override val filters
        : Optional[List[zio.aws.robomaker.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest
  ): zio.aws.robomaker.model.ListSimulationJobsRequest.ReadOnly = new Wrapper(
    impl
  )
}
