package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{CreatedAt, Id, Name, Arn}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Robot(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    fleetArn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.RobotStatus] = Optional.Absent,
    greenGrassGroupId: Optional[Id] = Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    architecture: Optional[zio.aws.robomaker.model.Architecture] =
      Optional.Absent,
    lastDeploymentJob: Optional[Arn] = Optional.Absent,
    lastDeploymentTime: Optional[CreatedAt] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.robomaker.model.Robot = {
    import Robot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.Robot
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        fleetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.fleetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        greenGrassGroupId.map(value => Id.unwrap(value): java.lang.String)
      )(_.greenGrassGroupId)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(architecture.map(value => value.unwrap))(_.architecture)
      .optionallyWith(
        lastDeploymentJob.map(value => Arn.unwrap(value): java.lang.String)
      )(_.lastDeploymentJob)
      .optionallyWith(
        lastDeploymentTime.map(value => CreatedAt.unwrap(value): Instant)
      )(_.lastDeploymentTime)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.Robot.ReadOnly =
    zio.aws.robomaker.model.Robot.wrap(buildAwsValue())
}
object Robot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.robomaker.model.Robot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.Robot =
      zio.aws.robomaker.model.Robot(
        arn.map(value => value),
        name.map(value => value),
        fleetArn.map(value => value),
        status.map(value => value),
        greenGrassGroupId.map(value => value),
        createdAt.map(value => value),
        architecture.map(value => value),
        lastDeploymentJob.map(value => value),
        lastDeploymentTime.map(value => value)
      )
    def arn: Optional[Arn]
    def name: Optional[Name]
    def fleetArn: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.RobotStatus]
    def greenGrassGroupId: Optional[Id]
    def createdAt: Optional[CreatedAt]
    def architecture: Optional[zio.aws.robomaker.model.Architecture]
    def lastDeploymentJob: Optional[Arn]
    def lastDeploymentTime: Optional[CreatedAt]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getFleetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("fleetArn", fleetArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.robomaker.model.RobotStatus] =
      AwsError.unwrapOptionField("status", status)
    def getGreenGrassGroupId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("greenGrassGroupId", greenGrassGroupId)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getArchitecture
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Architecture] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getLastDeploymentJob: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("lastDeploymentJob", lastDeploymentJob)
    def getLastDeploymentTime: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("lastDeploymentTime", lastDeploymentTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.Robot
  ) extends zio.aws.robomaker.model.Robot.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.robomaker.model.primitives.Name(value))
    override val fleetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.fleetArn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status: Optional[zio.aws.robomaker.model.RobotStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.robomaker.model.RobotStatus.wrap(value))
    override val greenGrassGroupId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.greenGrassGroupId())
      .map(value => zio.aws.robomaker.model.primitives.Id(value))
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val architecture: Optional[zio.aws.robomaker.model.Architecture] =
      zio.aws.core.internal
        .optionalFromNullable(impl.architecture())
        .map(value => zio.aws.robomaker.model.Architecture.wrap(value))
    override val lastDeploymentJob: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDeploymentJob())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val lastDeploymentTime: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.lastDeploymentTime())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.Robot
  ): zio.aws.robomaker.model.Robot.ReadOnly = new Wrapper(impl)
}
