package zio.aws.robomaker.model
import zio.aws.robomaker.model.primitives.{
  CreatedAt,
  GenericString,
  ClientRequestToken,
  TagValue,
  Arn,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class StartSimulationJobBatchResponse(
    arn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.robomaker.model.SimulationJobBatchStatus] =
      Optional.Absent,
    createdAt: Optional[CreatedAt] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    batchPolicy: Optional[zio.aws.robomaker.model.BatchPolicy] =
      Optional.Absent,
    failureCode: Optional[zio.aws.robomaker.model.SimulationJobBatchErrorCode] =
      Optional.Absent,
    failureReason: Optional[GenericString] = Optional.Absent,
    failedRequests: Optional[
      Iterable[zio.aws.robomaker.model.FailedCreateSimulationJobRequest]
    ] = Optional.Absent,
    pendingRequests: Optional[
      Iterable[zio.aws.robomaker.model.SimulationJobRequest]
    ] = Optional.Absent,
    createdRequests: Optional[
      Iterable[zio.aws.robomaker.model.SimulationJobSummary]
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse = {
    import StartSimulationJobBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(batchPolicy.map(value => value.buildAwsValue()))(
        _.batchPolicy
      )
      .optionallyWith(failureCode.map(value => value.unwrap))(_.failureCode)
      .optionallyWith(failureReason.map(value => value: java.lang.String))(
        _.failureReason
      )
      .optionallyWith(
        failedRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedRequests)
      .optionallyWith(
        pendingRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingRequests)
      .optionallyWith(
        createdRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createdRequests)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly =
    zio.aws.robomaker.model.StartSimulationJobBatchResponse
      .wrap(buildAwsValue())
}
object StartSimulationJobBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.StartSimulationJobBatchResponse =
      zio.aws.robomaker.model.StartSimulationJobBatchResponse(
        arn.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        clientRequestToken.map(value => value),
        batchPolicy.map(value => value.asEditable),
        failureCode.map(value => value),
        failureReason.map(value => value),
        failedRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def arn: Optional[Arn]
    def status: Optional[zio.aws.robomaker.model.SimulationJobBatchStatus]
    def createdAt: Optional[CreatedAt]
    def clientRequestToken: Optional[ClientRequestToken]
    def batchPolicy: Optional[zio.aws.robomaker.model.BatchPolicy.ReadOnly]
    def failureCode
        : Optional[zio.aws.robomaker.model.SimulationJobBatchErrorCode]
    def failureReason: Optional[GenericString]
    def failedRequests: Optional[
      List[zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly]
    ]
    def pendingRequests
        : Optional[List[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]]
    def createdRequests
        : Optional[List[zio.aws.robomaker.model.SimulationJobSummary.ReadOnly]]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.robomaker.model.SimulationJobBatchStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getBatchPolicy
        : ZIO[Any, AwsError, zio.aws.robomaker.model.BatchPolicy.ReadOnly] =
      AwsError.unwrapOptionField("batchPolicy", batchPolicy)
    def getFailureCode: ZIO[
      Any,
      AwsError,
      zio.aws.robomaker.model.SimulationJobBatchErrorCode
    ] = AwsError.unwrapOptionField("failureCode", failureCode)
    def getFailureReason: ZIO[Any, AwsError, GenericString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getFailedRequests: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("failedRequests", failedRequests)
    def getPendingRequests: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationJobRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("pendingRequests", pendingRequests)
    def getCreatedRequests: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SimulationJobSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("createdRequests", createdRequests)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse
  ) extends zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.robomaker.model.primitives.Arn(value))
    override val status
        : Optional[zio.aws.robomaker.model.SimulationJobBatchStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.robomaker.model.SimulationJobBatchStatus.wrap(value)
        )
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.robomaker.model.primitives.CreatedAt(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.robomaker.model.primitives.ClientRequestToken(value)
        )
    override val batchPolicy
        : Optional[zio.aws.robomaker.model.BatchPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchPolicy())
        .map(value => zio.aws.robomaker.model.BatchPolicy.wrap(value))
    override val failureCode
        : Optional[zio.aws.robomaker.model.SimulationJobBatchErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureCode())
        .map(value =>
          zio.aws.robomaker.model.SimulationJobBatchErrorCode.wrap(value)
        )
    override val failureReason: Optional[GenericString] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => value: GenericString)
    override val failedRequests: Optional[
      List[zio.aws.robomaker.model.FailedCreateSimulationJobRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.FailedCreateSimulationJobRequest.wrap(item)
        }.toList
      )
    override val pendingRequests: Optional[
      List[zio.aws.robomaker.model.SimulationJobRequest.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationJobRequest.wrap(item)
        }.toList
      )
    override val createdRequests: Optional[
      List[zio.aws.robomaker.model.SimulationJobSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createdRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.robomaker.model.SimulationJobSummary.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.robomaker.model.primitives
              .TagKey(key) -> zio.aws.robomaker.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse
  ): zio.aws.robomaker.model.StartSimulationJobBatchResponse.ReadOnly =
    new Wrapper(impl)
}
