package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.robomaker.model.primitives.{RevisionId, Arn}
import scala.jdk.CollectionConverters.*
final case class UpdateSimulationApplicationRequest(
    application: Arn,
    sources: Optional[Iterable[zio.aws.robomaker.model.SourceConfig]] =
      Optional.Absent,
    simulationSoftwareSuite: zio.aws.robomaker.model.SimulationSoftwareSuite,
    robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite,
    renderingEngine: Optional[zio.aws.robomaker.model.RenderingEngine] =
      Optional.Absent,
    currentRevisionId: Optional[RevisionId] = Optional.Absent,
    environment: Optional[zio.aws.robomaker.model.Environment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest = {
    import UpdateSimulationApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest
      .builder()
      .application(Arn.unwrap(application): java.lang.String)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .simulationSoftwareSuite(simulationSoftwareSuite.buildAwsValue())
      .robotSoftwareSuite(robotSoftwareSuite.buildAwsValue())
      .optionallyWith(renderingEngine.map(value => value.buildAwsValue()))(
        _.renderingEngine
      )
      .optionallyWith(
        currentRevisionId.map(value =>
          RevisionId.unwrap(value): java.lang.String
        )
      )(_.currentRevisionId)
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.robomaker.model.UpdateSimulationApplicationRequest.ReadOnly =
    zio.aws.robomaker.model.UpdateSimulationApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateSimulationApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UpdateSimulationApplicationRequest =
      zio.aws.robomaker.model.UpdateSimulationApplicationRequest(
        application,
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        simulationSoftwareSuite.asEditable,
        robotSoftwareSuite.asEditable,
        renderingEngine.map(value => value.asEditable),
        currentRevisionId.map(value => value),
        environment.map(value => value.asEditable)
      )
    def application: Arn
    def sources: Optional[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]]
    def simulationSoftwareSuite
        : zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly
    def robotSoftwareSuite: zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    def renderingEngine
        : Optional[zio.aws.robomaker.model.RenderingEngine.ReadOnly]
    def currentRevisionId: Optional[RevisionId]
    def environment: Optional[zio.aws.robomaker.model.Environment.ReadOnly]
    def getApplication: ZIO[Any, Nothing, Arn] = ZIO.succeed(application)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.robomaker.model.SourceConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getSimulationSoftwareSuite: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly
    ] = ZIO.succeed(simulationSoftwareSuite)
    def getRobotSoftwareSuite: ZIO[
      Any,
      Nothing,
      zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly
    ] = ZIO.succeed(robotSoftwareSuite)
    def getRenderingEngine
        : ZIO[Any, AwsError, zio.aws.robomaker.model.RenderingEngine.ReadOnly] =
      AwsError.unwrapOptionField("renderingEngine", renderingEngine)
    def getCurrentRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("currentRevisionId", currentRevisionId)
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.robomaker.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest
  ) extends zio.aws.robomaker.model.UpdateSimulationApplicationRequest.ReadOnly {
    override val application: Arn =
      zio.aws.robomaker.model.primitives.Arn(impl.application())
    override val sources
        : Optional[List[zio.aws.robomaker.model.SourceConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.robomaker.model.SourceConfig.wrap(item)
          }.toList
        )
    override val simulationSoftwareSuite
        : zio.aws.robomaker.model.SimulationSoftwareSuite.ReadOnly =
      zio.aws.robomaker.model.SimulationSoftwareSuite
        .wrap(impl.simulationSoftwareSuite())
    override val robotSoftwareSuite
        : zio.aws.robomaker.model.RobotSoftwareSuite.ReadOnly =
      zio.aws.robomaker.model.RobotSoftwareSuite.wrap(impl.robotSoftwareSuite())
    override val renderingEngine
        : Optional[zio.aws.robomaker.model.RenderingEngine.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renderingEngine())
        .map(value => zio.aws.robomaker.model.RenderingEngine.wrap(value))
    override val currentRevisionId: Optional[RevisionId] = zio.aws.core.internal
      .optionalFromNullable(impl.currentRevisionId())
      .map(value => zio.aws.robomaker.model.primitives.RevisionId(value))
    override val environment
        : Optional[zio.aws.robomaker.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.robomaker.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest
  ): zio.aws.robomaker.model.UpdateSimulationApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
