package zio.aws.robomaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.robomaker.model.primitives.{Path, Name}
import scala.jdk.CollectionConverters.*
final case class UploadConfiguration(
    name: Name,
    path: Path,
    uploadBehavior: zio.aws.robomaker.model.UploadBehavior
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.robomaker.model.UploadConfiguration = {
    import UploadConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.robomaker.model.UploadConfiguration
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .path(Path.unwrap(path): java.lang.String)
      .uploadBehavior(uploadBehavior.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.robomaker.model.UploadConfiguration.ReadOnly =
    zio.aws.robomaker.model.UploadConfiguration.wrap(buildAwsValue())
}
object UploadConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.robomaker.model.UploadConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.robomaker.model.UploadConfiguration =
      zio.aws.robomaker.model.UploadConfiguration(name, path, uploadBehavior)
    def name: Name
    def path: Path
    def uploadBehavior: zio.aws.robomaker.model.UploadBehavior
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getPath: ZIO[Any, Nothing, Path] = ZIO.succeed(path)
    def getUploadBehavior
        : ZIO[Any, Nothing, zio.aws.robomaker.model.UploadBehavior] =
      ZIO.succeed(uploadBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.robomaker.model.UploadConfiguration
  ) extends zio.aws.robomaker.model.UploadConfiguration.ReadOnly {
    override val name: Name =
      zio.aws.robomaker.model.primitives.Name(impl.name())
    override val path: Path =
      zio.aws.robomaker.model.primitives.Path(impl.path())
    override val uploadBehavior: zio.aws.robomaker.model.UploadBehavior =
      zio.aws.robomaker.model.UploadBehavior.wrap(impl.uploadBehavior())
  }
  def wrap(
      impl: software.amazon.awssdk.services.robomaker.model.UploadConfiguration
  ): zio.aws.robomaker.model.UploadConfiguration.ReadOnly = new Wrapper(impl)
}
