package zio.aws.robomaker.model
import scala.jdk.CollectionConverters.*
sealed trait WorldGenerationJobStatus {
  def unwrap
      : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus
}
object WorldGenerationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus
  ): zio.aws.robomaker.model.WorldGenerationJobStatus = value match {
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.RUNNING =>
      val r = Running
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.PARTIAL_FAILED =>
      val r = PartialFailed
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.CANCELING =>
      val r = Canceling
      r
    case software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.CANCELED =>
      val r = Canceled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.PENDING
  }
  case object Running extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.RUNNING
  }
  case object Completed
      extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.FAILED
  }
  case object PartialFailed
      extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.PARTIAL_FAILED
  }
  case object Canceling
      extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.CANCELING
  }
  case object Canceled
      extends zio.aws.robomaker.model.WorldGenerationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus =
      software.amazon.awssdk.services.robomaker.model.WorldGenerationJobStatus.CANCELED
  }
}
