package zio.aws.route53
import zio.aws.route53.model.CollectionSummary.ReadOnly
import software.amazon.awssdk.services.route53.Route53AsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.route53.model.{
  ListHostedZonesRequest,
  GetHealthCheckLastFailureReasonRequest,
  ListHostedZonesByNameRequest,
  GetHostedZoneRequest,
  ListTrafficPoliciesRequest,
  CreateTrafficPolicyInstanceRequest,
  ListHealthChecksRequest,
  GetHealthCheckRequest,
  GetChangeRequest,
  ListQueryLoggingConfigsRequest,
  UpdateHostedZoneCommentRequest,
  CreateQueryLoggingConfigRequest,
  ListCidrLocationsRequest,
  GetQueryLoggingConfigRequest,
  ListCidrBlocksRequest,
  DeleteHealthCheckRequest,
  TestDnsAnswerRequest,
  DeleteQueryLoggingConfigRequest,
  GetCheckerIpRangesRequest,
  DeleteVpcAssociationAuthorizationRequest,
  DeleteHostedZoneRequest,
  ListResourceRecordSetsRequest,
  ListReusableDelegationSetsRequest,
  UpdateTrafficPolicyCommentRequest,
  ListTagsForResourceRequest,
  DeleteCidrCollectionRequest,
  UpdateHealthCheckRequest,
  ChangeResourceRecordSetsRequest,
  ListTrafficPolicyInstancesRequest,
  CreateTrafficPolicyRequest,
  DisassociateVpcFromHostedZoneRequest,
  GetReusableDelegationSetRequest,
  ListTagsForResourcesRequest,
  GetHealthCheckCountRequest,
  CreateHostedZoneRequest,
  DisableHostedZoneDnssecRequest,
  ListHostedZonesByVpcRequest,
  DeactivateKeySigningKeyRequest,
  CreateReusableDelegationSetRequest,
  ListVpcAssociationAuthorizationsRequest,
  GetTrafficPolicyInstanceCountRequest,
  GetReusableDelegationSetLimitRequest,
  ListTrafficPolicyInstancesByHostedZoneRequest,
  DeleteTrafficPolicyRequest,
  GetDnssecRequest,
  DeleteKeySigningKeyRequest,
  ActivateKeySigningKeyRequest,
  ListCidrCollectionsRequest,
  AssociateVpcWithHostedZoneRequest,
  DeleteReusableDelegationSetRequest,
  GetHealthCheckStatusRequest,
  GetAccountLimitRequest,
  DeleteTrafficPolicyInstanceRequest,
  CreateTrafficPolicyVersionRequest,
  CreateHealthCheckRequest,
  ChangeTagsForResourceRequest,
  ListTrafficPolicyInstancesByPolicyRequest,
  ChangeCidrCollectionRequest,
  CreateKeySigningKeyRequest,
  ListTrafficPolicyVersionsRequest,
  EnableHostedZoneDnssecRequest,
  UpdateTrafficPolicyInstanceRequest,
  GetHostedZoneCountRequest,
  GetHostedZoneLimitRequest,
  GetTrafficPolicyInstanceRequest,
  GetGeoLocationRequest,
  CreateCidrCollectionRequest,
  GetTrafficPolicyRequest,
  ListGeoLocationsRequest,
  CreateVpcAssociationAuthorizationRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object Route53Mock extends Mock[Route53] {
  object ListQueryLoggingConfigs
      extends Stream[
        ListQueryLoggingConfigsRequest,
        AwsError,
        zio.aws.route53.model.QueryLoggingConfig.ReadOnly
      ]
  object ListQueryLoggingConfigsPaginated
      extends Effect[
        ListQueryLoggingConfigsRequest,
        AwsError,
        zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly
      ]
  object ListTrafficPolicyVersions
      extends Effect[
        ListTrafficPolicyVersionsRequest,
        AwsError,
        zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly
      ]
  object ActivateKeySigningKey
      extends Effect[
        ActivateKeySigningKeyRequest,
        AwsError,
        zio.aws.route53.model.ActivateKeySigningKeyResponse.ReadOnly
      ]
  object DeleteKeySigningKey
      extends Effect[
        DeleteKeySigningKeyRequest,
        AwsError,
        zio.aws.route53.model.DeleteKeySigningKeyResponse.ReadOnly
      ]
  object DeleteReusableDelegationSet
      extends Effect[
        DeleteReusableDelegationSetRequest,
        AwsError,
        zio.aws.route53.model.DeleteReusableDelegationSetResponse.ReadOnly
      ]
  object TestDNSAnswer
      extends Effect[
        TestDnsAnswerRequest,
        AwsError,
        zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly
      ]
  object DeleteHostedZone
      extends Effect[
        DeleteHostedZoneRequest,
        AwsError,
        zio.aws.route53.model.DeleteHostedZoneResponse.ReadOnly
      ]
  object CreateVPCAssociationAuthorization
      extends Effect[
        CreateVpcAssociationAuthorizationRequest,
        AwsError,
        zio.aws.route53.model.CreateVpcAssociationAuthorizationResponse.ReadOnly
      ]
  object ListHostedZonesByName
      extends Effect[
        ListHostedZonesByNameRequest,
        AwsError,
        zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly
      ]
  object CreateTrafficPolicy
      extends Effect[
        CreateTrafficPolicyRequest,
        AwsError,
        zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly
      ]
  object ListCidrBlocks
      extends Stream[
        ListCidrBlocksRequest,
        AwsError,
        zio.aws.route53.model.CidrBlockSummary.ReadOnly
      ]
  object ListCidrBlocksPaginated
      extends Effect[
        ListCidrBlocksRequest,
        AwsError,
        zio.aws.route53.model.ListCidrBlocksResponse.ReadOnly
      ]
  object GetReusableDelegationSetLimit
      extends Effect[
        GetReusableDelegationSetLimitRequest,
        AwsError,
        zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly
      ]
  object CreateTrafficPolicyVersion
      extends Effect[
        CreateTrafficPolicyVersionRequest,
        AwsError,
        zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly
      ]
  object ChangeResourceRecordSets
      extends Effect[
        ChangeResourceRecordSetsRequest,
        AwsError,
        zio.aws.route53.model.ChangeResourceRecordSetsResponse.ReadOnly
      ]
  object GetCheckerIpRanges
      extends Effect[
        GetCheckerIpRangesRequest,
        AwsError,
        zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly
      ]
  object CreateCidrCollection
      extends Effect[
        CreateCidrCollectionRequest,
        AwsError,
        zio.aws.route53.model.CreateCidrCollectionResponse.ReadOnly
      ]
  object GetHostedZoneLimit
      extends Effect[
        GetHostedZoneLimitRequest,
        AwsError,
        zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly
      ]
  object ListHealthChecks
      extends Stream[
        ListHealthChecksRequest,
        AwsError,
        zio.aws.route53.model.HealthCheck.ReadOnly
      ]
  object ListHealthChecksPaginated
      extends Effect[
        ListHealthChecksRequest,
        AwsError,
        zio.aws.route53.model.ListHealthChecksResponse.ReadOnly
      ]
  object GetAccountLimit
      extends Effect[
        GetAccountLimitRequest,
        AwsError,
        zio.aws.route53.model.GetAccountLimitResponse.ReadOnly
      ]
  object GetHealthCheck
      extends Effect[
        GetHealthCheckRequest,
        AwsError,
        zio.aws.route53.model.GetHealthCheckResponse.ReadOnly
      ]
  object DeleteTrafficPolicy
      extends Effect[
        DeleteTrafficPolicyRequest,
        AwsError,
        zio.aws.route53.model.DeleteTrafficPolicyResponse.ReadOnly
      ]
  object ListCidrLocations
      extends Stream[
        ListCidrLocationsRequest,
        AwsError,
        zio.aws.route53.model.LocationSummary.ReadOnly
      ]
  object ListCidrLocationsPaginated
      extends Effect[
        ListCidrLocationsRequest,
        AwsError,
        zio.aws.route53.model.ListCidrLocationsResponse.ReadOnly
      ]
  object ListHostedZonesByVPC
      extends Effect[
        ListHostedZonesByVpcRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly,
          zio.aws.route53.model.HostedZoneSummary.ReadOnly
        ]
      ]
  object ListHostedZonesByVPCPaginated
      extends Effect[
        ListHostedZonesByVpcRequest,
        AwsError,
        zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly
      ]
  object ChangeTagsForResource
      extends Effect[
        ChangeTagsForResourceRequest,
        AwsError,
        zio.aws.route53.model.ChangeTagsForResourceResponse.ReadOnly
      ]
  object DisableHostedZoneDNSSEC
      extends Effect[
        DisableHostedZoneDnssecRequest,
        AwsError,
        zio.aws.route53.model.DisableHostedZoneDnssecResponse.ReadOnly
      ]
  object CreateKeySigningKey
      extends Effect[
        CreateKeySigningKeyRequest,
        AwsError,
        zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly
      ]
  object ListTrafficPolicies
      extends Effect[
        ListTrafficPoliciesRequest,
        AwsError,
        zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly
      ]
  object DeleteVPCAssociationAuthorization
      extends Effect[
        DeleteVpcAssociationAuthorizationRequest,
        AwsError,
        zio.aws.route53.model.DeleteVpcAssociationAuthorizationResponse.ReadOnly
      ]
  object GetHealthCheckLastFailureReason
      extends Effect[
        GetHealthCheckLastFailureReasonRequest,
        AwsError,
        zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly
      ]
  object EnableHostedZoneDNSSEC
      extends Effect[
        EnableHostedZoneDnssecRequest,
        AwsError,
        zio.aws.route53.model.EnableHostedZoneDnssecResponse.ReadOnly
      ]
  object CreateHealthCheck
      extends Effect[
        CreateHealthCheckRequest,
        AwsError,
        zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly
      ]
  object DisassociateVPCFromHostedZone
      extends Effect[
        DisassociateVpcFromHostedZoneRequest,
        AwsError,
        zio.aws.route53.model.DisassociateVpcFromHostedZoneResponse.ReadOnly
      ]
  object CreateReusableDelegationSet
      extends Effect[
        CreateReusableDelegationSetRequest,
        AwsError,
        zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly
      ]
  object UpdateHealthCheck
      extends Effect[
        UpdateHealthCheckRequest,
        AwsError,
        zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly
      ]
  object GetHealthCheckCount
      extends Effect[
        GetHealthCheckCountRequest,
        AwsError,
        zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly
      ]
  object ListHostedZones
      extends Stream[
        ListHostedZonesRequest,
        AwsError,
        zio.aws.route53.model.HostedZone.ReadOnly
      ]
  object ListHostedZonesPaginated
      extends Effect[
        ListHostedZonesRequest,
        AwsError,
        zio.aws.route53.model.ListHostedZonesResponse.ReadOnly
      ]
  object ListCidrCollections
      extends Stream[ListCidrCollectionsRequest, AwsError, ReadOnly]
  object ListCidrCollectionsPaginated
      extends Effect[
        ListCidrCollectionsRequest,
        AwsError,
        zio.aws.route53.model.ListCidrCollectionsResponse.ReadOnly
      ]
  object CreateHostedZone
      extends Effect[
        CreateHostedZoneRequest,
        AwsError,
        zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly
      ]
  object UpdateHostedZoneComment
      extends Effect[
        UpdateHostedZoneCommentRequest,
        AwsError,
        zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly
      ]
  object ListTrafficPolicyInstances
      extends Effect[
        ListTrafficPolicyInstancesRequest,
        AwsError,
        zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly
      ]
  object GetTrafficPolicyInstanceCount
      extends Effect[
        GetTrafficPolicyInstanceCountRequest,
        AwsError,
        zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly
      ]
  object DeleteQueryLoggingConfig
      extends Effect[
        DeleteQueryLoggingConfigRequest,
        AwsError,
        zio.aws.route53.model.DeleteQueryLoggingConfigResponse.ReadOnly
      ]
  object DeleteTrafficPolicyInstance
      extends Effect[
        DeleteTrafficPolicyInstanceRequest,
        AwsError,
        zio.aws.route53.model.DeleteTrafficPolicyInstanceResponse.ReadOnly
      ]
  object ListTrafficPolicyInstancesByHostedZone
      extends Effect[
        ListTrafficPolicyInstancesByHostedZoneRequest,
        AwsError,
        zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse.ReadOnly
      ]
  object GetChange
      extends Effect[
        GetChangeRequest,
        AwsError,
        zio.aws.route53.model.GetChangeResponse.ReadOnly
      ]
  object ListResourceRecordSets
      extends Stream[
        ListResourceRecordSetsRequest,
        AwsError,
        zio.aws.route53.model.ResourceRecordSet.ReadOnly
      ]
  object ListResourceRecordSetsPaginated
      extends Effect[
        ListResourceRecordSetsRequest,
        AwsError,
        zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly
      ]
  object ListGeoLocations
      extends Effect[
        ListGeoLocationsRequest,
        AwsError,
        zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly
      ]
  object UpdateTrafficPolicyInstance
      extends Effect[
        UpdateTrafficPolicyInstanceRequest,
        AwsError,
        zio.aws.route53.model.UpdateTrafficPolicyInstanceResponse.ReadOnly
      ]
  object GetQueryLoggingConfig
      extends Effect[
        GetQueryLoggingConfigRequest,
        AwsError,
        zio.aws.route53.model.GetQueryLoggingConfigResponse.ReadOnly
      ]
  object DeleteCidrCollection
      extends Effect[
        DeleteCidrCollectionRequest,
        AwsError,
        zio.aws.route53.model.DeleteCidrCollectionResponse.ReadOnly
      ]
  object GetTrafficPolicyInstance
      extends Effect[
        GetTrafficPolicyInstanceRequest,
        AwsError,
        zio.aws.route53.model.GetTrafficPolicyInstanceResponse.ReadOnly
      ]
  object GetHostedZone
      extends Effect[
        GetHostedZoneRequest,
        AwsError,
        zio.aws.route53.model.GetHostedZoneResponse.ReadOnly
      ]
  object DeleteHealthCheck
      extends Effect[
        DeleteHealthCheckRequest,
        AwsError,
        zio.aws.route53.model.DeleteHealthCheckResponse.ReadOnly
      ]
  object GetHealthCheckStatus
      extends Effect[
        GetHealthCheckStatusRequest,
        AwsError,
        zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListVPCAssociationAuthorizations
      extends Effect[ListVpcAssociationAuthorizationsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly,
        zio.aws.route53.model.VPC.ReadOnly
      ]]
  object ListVPCAssociationAuthorizationsPaginated
      extends Effect[
        ListVpcAssociationAuthorizationsRequest,
        AwsError,
        zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly
      ]
  object ListReusableDelegationSets
      extends Effect[
        ListReusableDelegationSetsRequest,
        AwsError,
        zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly
      ]
  object GetHostedZoneCount
      extends Effect[
        GetHostedZoneCountRequest,
        AwsError,
        zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly
      ]
  object DeactivateKeySigningKey
      extends Effect[
        DeactivateKeySigningKeyRequest,
        AwsError,
        zio.aws.route53.model.DeactivateKeySigningKeyResponse.ReadOnly
      ]
  object GetGeoLocation
      extends Effect[
        GetGeoLocationRequest,
        AwsError,
        zio.aws.route53.model.GetGeoLocationResponse.ReadOnly
      ]
  object GetReusableDelegationSet
      extends Effect[
        GetReusableDelegationSetRequest,
        AwsError,
        zio.aws.route53.model.GetReusableDelegationSetResponse.ReadOnly
      ]
  object UpdateTrafficPolicyComment
      extends Effect[
        UpdateTrafficPolicyCommentRequest,
        AwsError,
        zio.aws.route53.model.UpdateTrafficPolicyCommentResponse.ReadOnly
      ]
  object GetDNSSEC
      extends Effect[
        GetDnssecRequest,
        AwsError,
        zio.aws.route53.model.GetDnssecResponse.ReadOnly
      ]
  object AssociateVPCWithHostedZone
      extends Effect[
        AssociateVpcWithHostedZoneRequest,
        AwsError,
        zio.aws.route53.model.AssociateVpcWithHostedZoneResponse.ReadOnly
      ]
  object ListTrafficPolicyInstancesByPolicy
      extends Effect[
        ListTrafficPolicyInstancesByPolicyRequest,
        AwsError,
        zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyResponse.ReadOnly
      ]
  object GetTrafficPolicy
      extends Effect[
        GetTrafficPolicyRequest,
        AwsError,
        zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly
      ]
  object CreateQueryLoggingConfig
      extends Effect[
        CreateQueryLoggingConfigRequest,
        AwsError,
        zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly
      ]
  object ChangeCidrCollection
      extends Effect[
        ChangeCidrCollectionRequest,
        AwsError,
        zio.aws.route53.model.ChangeCidrCollectionResponse.ReadOnly
      ]
  object CreateTrafficPolicyInstance
      extends Effect[
        CreateTrafficPolicyInstanceRequest,
        AwsError,
        zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly
      ]
  object ListTagsForResources
      extends Effect[
        ListTagsForResourcesRequest,
        AwsError,
        zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Route53] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Route53] { rts =>
        ZIO.succeed {
          new Route53 {
            val api: Route53AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Route53 = this
            def listQueryLoggingConfigs(
                request: ListQueryLoggingConfigsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53.model.QueryLoggingConfig.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListQueryLoggingConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listQueryLoggingConfigsPaginated(
                request: ListQueryLoggingConfigsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly
            ] = proxy(ListQueryLoggingConfigsPaginated, request)
            def listTrafficPolicyVersions(
                request: ListTrafficPolicyVersionsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly
            ] = proxy(ListTrafficPolicyVersions, request)
            def activateKeySigningKey(
                request: ActivateKeySigningKeyRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ActivateKeySigningKeyResponse.ReadOnly
            ] = proxy(ActivateKeySigningKey, request)
            def deleteKeySigningKey(request: DeleteKeySigningKeyRequest): IO[
              AwsError,
              zio.aws.route53.model.DeleteKeySigningKeyResponse.ReadOnly
            ] = proxy(DeleteKeySigningKey, request)
            def deleteReusableDelegationSet(
                request: DeleteReusableDelegationSetRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DeleteReusableDelegationSetResponse.ReadOnly
            ] = proxy(DeleteReusableDelegationSet, request)
            def testDNSAnswer(request: TestDnsAnswerRequest): IO[
              AwsError,
              zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly
            ] = proxy(TestDNSAnswer, request)
            def deleteHostedZone(request: DeleteHostedZoneRequest): IO[
              AwsError,
              zio.aws.route53.model.DeleteHostedZoneResponse.ReadOnly
            ] = proxy(DeleteHostedZone, request)
            def createVPCAssociationAuthorization(
                request: CreateVpcAssociationAuthorizationRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.CreateVpcAssociationAuthorizationResponse.ReadOnly
            ] = proxy(CreateVPCAssociationAuthorization, request)
            def listHostedZonesByName(
                request: ListHostedZonesByNameRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly
            ] = proxy(ListHostedZonesByName, request)
            def createTrafficPolicy(request: CreateTrafficPolicyRequest): IO[
              AwsError,
              zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly
            ] = proxy(CreateTrafficPolicy, request)
            def listCidrBlocks(request: ListCidrBlocksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53.model.CidrBlockSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCidrBlocks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCidrBlocksPaginated(request: ListCidrBlocksRequest): IO[
              AwsError,
              zio.aws.route53.model.ListCidrBlocksResponse.ReadOnly
            ] = proxy(ListCidrBlocksPaginated, request)
            def getReusableDelegationSetLimit(
                request: GetReusableDelegationSetLimitRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly
            ] = proxy(GetReusableDelegationSetLimit, request)
            def createTrafficPolicyVersion(
                request: CreateTrafficPolicyVersionRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly
            ] = proxy(CreateTrafficPolicyVersion, request)
            def changeResourceRecordSets(
                request: ChangeResourceRecordSetsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ChangeResourceRecordSetsResponse.ReadOnly
            ] = proxy(ChangeResourceRecordSets, request)
            def getCheckerIpRanges(request: GetCheckerIpRangesRequest): IO[
              AwsError,
              zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly
            ] = proxy(GetCheckerIpRanges, request)
            def createCidrCollection(request: CreateCidrCollectionRequest): IO[
              AwsError,
              zio.aws.route53.model.CreateCidrCollectionResponse.ReadOnly
            ] = proxy(CreateCidrCollection, request)
            def getHostedZoneLimit(request: GetHostedZoneLimitRequest): IO[
              AwsError,
              zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly
            ] = proxy(GetHostedZoneLimit, request)
            def listHealthChecks(request: ListHealthChecksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53.model.HealthCheck.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHealthChecks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHealthChecksPaginated(request: ListHealthChecksRequest): IO[
              AwsError,
              zio.aws.route53.model.ListHealthChecksResponse.ReadOnly
            ] = proxy(ListHealthChecksPaginated, request)
            def getAccountLimit(request: GetAccountLimitRequest): IO[
              AwsError,
              zio.aws.route53.model.GetAccountLimitResponse.ReadOnly
            ] = proxy(GetAccountLimit, request)
            def getHealthCheck(request: GetHealthCheckRequest): IO[
              AwsError,
              zio.aws.route53.model.GetHealthCheckResponse.ReadOnly
            ] = proxy(GetHealthCheck, request)
            def deleteTrafficPolicy(request: DeleteTrafficPolicyRequest): IO[
              AwsError,
              zio.aws.route53.model.DeleteTrafficPolicyResponse.ReadOnly
            ] = proxy(DeleteTrafficPolicy, request)
            def listCidrLocations(request: ListCidrLocationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53.model.LocationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCidrLocations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCidrLocationsPaginated(
                request: ListCidrLocationsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListCidrLocationsResponse.ReadOnly
            ] = proxy(ListCidrLocationsPaginated, request)
            def listHostedZonesByVPC(
                request: ListHostedZonesByVpcRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly,
              zio.aws.route53.model.HostedZoneSummary.ReadOnly
            ]] = proxy(ListHostedZonesByVPC, request)
            def listHostedZonesByVPCPaginated(
                request: ListHostedZonesByVpcRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly
            ] = proxy(ListHostedZonesByVPCPaginated, request)
            def changeTagsForResource(
                request: ChangeTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ChangeTagsForResourceResponse.ReadOnly
            ] = proxy(ChangeTagsForResource, request)
            def disableHostedZoneDNSSEC(
                request: DisableHostedZoneDnssecRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DisableHostedZoneDnssecResponse.ReadOnly
            ] = proxy(DisableHostedZoneDNSSEC, request)
            def createKeySigningKey(request: CreateKeySigningKeyRequest): IO[
              AwsError,
              zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly
            ] = proxy(CreateKeySigningKey, request)
            def listTrafficPolicies(request: ListTrafficPoliciesRequest): IO[
              AwsError,
              zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly
            ] = proxy(ListTrafficPolicies, request)
            def deleteVPCAssociationAuthorization(
                request: DeleteVpcAssociationAuthorizationRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DeleteVpcAssociationAuthorizationResponse.ReadOnly
            ] = proxy(DeleteVPCAssociationAuthorization, request)
            def getHealthCheckLastFailureReason(
                request: GetHealthCheckLastFailureReasonRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly
            ] = proxy(GetHealthCheckLastFailureReason, request)
            def enableHostedZoneDNSSEC(
                request: EnableHostedZoneDnssecRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.EnableHostedZoneDnssecResponse.ReadOnly
            ] = proxy(EnableHostedZoneDNSSEC, request)
            def createHealthCheck(request: CreateHealthCheckRequest): IO[
              AwsError,
              zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly
            ] = proxy(CreateHealthCheck, request)
            def disassociateVPCFromHostedZone(
                request: DisassociateVpcFromHostedZoneRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DisassociateVpcFromHostedZoneResponse.ReadOnly
            ] = proxy(DisassociateVPCFromHostedZone, request)
            def createReusableDelegationSet(
                request: CreateReusableDelegationSetRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly
            ] = proxy(CreateReusableDelegationSet, request)
            def updateHealthCheck(request: UpdateHealthCheckRequest): IO[
              AwsError,
              zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly
            ] = proxy(UpdateHealthCheck, request)
            def getHealthCheckCount(request: GetHealthCheckCountRequest): IO[
              AwsError,
              zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly
            ] = proxy(GetHealthCheckCount, request)
            def listHostedZones(request: ListHostedZonesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.route53.model.HostedZone.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListHostedZones, request)
                }
                .getOrThrowFiberFailure()
            }
            def listHostedZonesPaginated(request: ListHostedZonesRequest): IO[
              AwsError,
              zio.aws.route53.model.ListHostedZonesResponse.ReadOnly
            ] = proxy(ListHostedZonesPaginated, request)
            def listCidrCollections(
                request: ListCidrCollectionsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListCidrCollections, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listCidrCollectionsPaginated(
                request: ListCidrCollectionsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListCidrCollectionsResponse.ReadOnly
            ] = proxy(ListCidrCollectionsPaginated, request)
            def createHostedZone(request: CreateHostedZoneRequest): IO[
              AwsError,
              zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly
            ] = proxy(CreateHostedZone, request)
            def updateHostedZoneComment(
                request: UpdateHostedZoneCommentRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly
            ] = proxy(UpdateHostedZoneComment, request)
            def listTrafficPolicyInstances(
                request: ListTrafficPolicyInstancesRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly
            ] = proxy(ListTrafficPolicyInstances, request)
            def getTrafficPolicyInstanceCount(
                request: GetTrafficPolicyInstanceCountRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly
            ] = proxy(GetTrafficPolicyInstanceCount, request)
            def deleteQueryLoggingConfig(
                request: DeleteQueryLoggingConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DeleteQueryLoggingConfigResponse.ReadOnly
            ] = proxy(DeleteQueryLoggingConfig, request)
            def deleteTrafficPolicyInstance(
                request: DeleteTrafficPolicyInstanceRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DeleteTrafficPolicyInstanceResponse.ReadOnly
            ] = proxy(DeleteTrafficPolicyInstance, request)
            def listTrafficPolicyInstancesByHostedZone(
                request: ListTrafficPolicyInstancesByHostedZoneRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse.ReadOnly
            ] = proxy(ListTrafficPolicyInstancesByHostedZone, request)
            def getChange(
                request: GetChangeRequest
            ): IO[AwsError, zio.aws.route53.model.GetChangeResponse.ReadOnly] =
              proxy(GetChange, request)
            def listResourceRecordSets(
                request: ListResourceRecordSetsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.route53.model.ResourceRecordSet.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListResourceRecordSets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listResourceRecordSetsPaginated(
                request: ListResourceRecordSetsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly
            ] = proxy(ListResourceRecordSetsPaginated, request)
            def listGeoLocations(request: ListGeoLocationsRequest): IO[
              AwsError,
              zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly
            ] = proxy(ListGeoLocations, request)
            def updateTrafficPolicyInstance(
                request: UpdateTrafficPolicyInstanceRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.UpdateTrafficPolicyInstanceResponse.ReadOnly
            ] = proxy(UpdateTrafficPolicyInstance, request)
            def getQueryLoggingConfig(
                request: GetQueryLoggingConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.GetQueryLoggingConfigResponse.ReadOnly
            ] = proxy(GetQueryLoggingConfig, request)
            def deleteCidrCollection(request: DeleteCidrCollectionRequest): IO[
              AwsError,
              zio.aws.route53.model.DeleteCidrCollectionResponse.ReadOnly
            ] = proxy(DeleteCidrCollection, request)
            def getTrafficPolicyInstance(
                request: GetTrafficPolicyInstanceRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.GetTrafficPolicyInstanceResponse.ReadOnly
            ] = proxy(GetTrafficPolicyInstance, request)
            def getHostedZone(request: GetHostedZoneRequest): IO[
              AwsError,
              zio.aws.route53.model.GetHostedZoneResponse.ReadOnly
            ] = proxy(GetHostedZone, request)
            def deleteHealthCheck(request: DeleteHealthCheckRequest): IO[
              AwsError,
              zio.aws.route53.model.DeleteHealthCheckResponse.ReadOnly
            ] = proxy(DeleteHealthCheck, request)
            def getHealthCheckStatus(request: GetHealthCheckStatusRequest): IO[
              AwsError,
              zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly
            ] = proxy(GetHealthCheckStatus, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listVPCAssociationAuthorizations(
                request: ListVpcAssociationAuthorizationsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly,
              zio.aws.route53.model.VPC.ReadOnly
            ]] = proxy(ListVPCAssociationAuthorizations, request)
            def listVPCAssociationAuthorizationsPaginated(
                request: ListVpcAssociationAuthorizationsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly
            ] = proxy(ListVPCAssociationAuthorizationsPaginated, request)
            def listReusableDelegationSets(
                request: ListReusableDelegationSetsRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly
            ] = proxy(ListReusableDelegationSets, request)
            def getHostedZoneCount(request: GetHostedZoneCountRequest): IO[
              AwsError,
              zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly
            ] = proxy(GetHostedZoneCount, request)
            def deactivateKeySigningKey(
                request: DeactivateKeySigningKeyRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.DeactivateKeySigningKeyResponse.ReadOnly
            ] = proxy(DeactivateKeySigningKey, request)
            def getGeoLocation(request: GetGeoLocationRequest): IO[
              AwsError,
              zio.aws.route53.model.GetGeoLocationResponse.ReadOnly
            ] = proxy(GetGeoLocation, request)
            def getReusableDelegationSet(
                request: GetReusableDelegationSetRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.GetReusableDelegationSetResponse.ReadOnly
            ] = proxy(GetReusableDelegationSet, request)
            def updateTrafficPolicyComment(
                request: UpdateTrafficPolicyCommentRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.UpdateTrafficPolicyCommentResponse.ReadOnly
            ] = proxy(UpdateTrafficPolicyComment, request)
            def getDNSSEC(
                request: GetDnssecRequest
            ): IO[AwsError, zio.aws.route53.model.GetDnssecResponse.ReadOnly] =
              proxy(GetDNSSEC, request)
            def associateVPCWithHostedZone(
                request: AssociateVpcWithHostedZoneRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.AssociateVpcWithHostedZoneResponse.ReadOnly
            ] = proxy(AssociateVPCWithHostedZone, request)
            def listTrafficPolicyInstancesByPolicy(
                request: ListTrafficPolicyInstancesByPolicyRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyResponse.ReadOnly
            ] = proxy(ListTrafficPolicyInstancesByPolicy, request)
            def getTrafficPolicy(request: GetTrafficPolicyRequest): IO[
              AwsError,
              zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly
            ] = proxy(GetTrafficPolicy, request)
            def createQueryLoggingConfig(
                request: CreateQueryLoggingConfigRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly
            ] = proxy(CreateQueryLoggingConfig, request)
            def changeCidrCollection(request: ChangeCidrCollectionRequest): IO[
              AwsError,
              zio.aws.route53.model.ChangeCidrCollectionResponse.ReadOnly
            ] = proxy(ChangeCidrCollection, request)
            def createTrafficPolicyInstance(
                request: CreateTrafficPolicyInstanceRequest
            ): IO[
              AwsError,
              zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly
            ] = proxy(CreateTrafficPolicyInstance, request)
            def listTagsForResources(request: ListTagsForResourcesRequest): IO[
              AwsError,
              zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly
            ] = proxy(ListTagsForResources, request)
          }
        }
      }
    }
  }
}
