package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait AccountLimitType {
  def unwrap: software.amazon.awssdk.services.route53.model.AccountLimitType
}
object AccountLimitType {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.AccountLimitType
  ): zio.aws.route53.model.AccountLimitType = value match {
    case software.amazon.awssdk.services.route53.model.AccountLimitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_HEALTH_CHECKS_BY_OWNER =>
      val r = MAX_HEALTH_CHECKS_BY_OWNER
      r
    case software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_HOSTED_ZONES_BY_OWNER =>
      val r = MAX_HOSTED_ZONES_BY_OWNER
      r
    case software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER =>
      val r = MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER
      r
    case software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_REUSABLE_DELEGATION_SETS_BY_OWNER =>
      val r = MAX_REUSABLE_DELEGATION_SETS_BY_OWNER
      r
    case software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_TRAFFIC_POLICIES_BY_OWNER =>
      val r = MAX_TRAFFIC_POLICIES_BY_OWNER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.AccountLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.AccountLimitType =
      software.amazon.awssdk.services.route53.model.AccountLimitType.UNKNOWN_TO_SDK_VERSION
  }
  case object MAX_HEALTH_CHECKS_BY_OWNER
      extends zio.aws.route53.model.AccountLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.AccountLimitType =
      software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_HEALTH_CHECKS_BY_OWNER
  }
  case object MAX_HOSTED_ZONES_BY_OWNER
      extends zio.aws.route53.model.AccountLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.AccountLimitType =
      software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_HOSTED_ZONES_BY_OWNER
  }
  case object MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER
      extends zio.aws.route53.model.AccountLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.AccountLimitType =
      software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER
  }
  case object MAX_REUSABLE_DELEGATION_SETS_BY_OWNER
      extends zio.aws.route53.model.AccountLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.AccountLimitType =
      software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_REUSABLE_DELEGATION_SETS_BY_OWNER
  }
  case object MAX_TRAFFIC_POLICIES_BY_OWNER
      extends zio.aws.route53.model.AccountLimitType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.AccountLimitType =
      software.amazon.awssdk.services.route53.model.AccountLimitType.MAX_TRAFFIC_POLICIES_BY_OWNER
  }
}
