package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  AliasHealthEnabled,
  DNSName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class AliasTarget(
    hostedZoneId: ResourceId,
    dnsName: DNSName,
    evaluateTargetHealth: AliasHealthEnabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.AliasTarget = {
    import AliasTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.AliasTarget
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .dnsName(DNSName.unwrap(dnsName): java.lang.String)
      .evaluateTargetHealth(
        AliasHealthEnabled.unwrap(evaluateTargetHealth): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.AliasTarget.ReadOnly =
    zio.aws.route53.model.AliasTarget.wrap(buildAwsValue())
}
object AliasTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.AliasTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.AliasTarget = zio.aws.route53.model
      .AliasTarget(hostedZoneId, dnsName, evaluateTargetHealth)
    def hostedZoneId: ResourceId
    def dnsName: DNSName
    def evaluateTargetHealth: AliasHealthEnabled
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getDnsName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(dnsName)
    def getEvaluateTargetHealth: ZIO[Any, Nothing, AliasHealthEnabled] =
      ZIO.succeed(evaluateTargetHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.AliasTarget
  ) extends zio.aws.route53.model.AliasTarget.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val dnsName: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.dnsName())
    override val evaluateTargetHealth: AliasHealthEnabled =
      zio.aws.route53.model.primitives
        .AliasHealthEnabled(impl.evaluateTargetHealth())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.AliasTarget
  ): zio.aws.route53.model.AliasTarget.ReadOnly = new Wrapper(impl)
}
