package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait ChangeAction {
  def unwrap: software.amazon.awssdk.services.route53.model.ChangeAction
}
object ChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.ChangeAction
  ): zio.aws.route53.model.ChangeAction = value match {
    case software.amazon.awssdk.services.route53.model.ChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.ChangeAction.CREATE =>
      val r = CREATE
      r
    case software.amazon.awssdk.services.route53.model.ChangeAction.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.route53.model.ChangeAction.UPSERT =>
      val r = UPSERT
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeAction =
      software.amazon.awssdk.services.route53.model.ChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE extends zio.aws.route53.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeAction =
      software.amazon.awssdk.services.route53.model.ChangeAction.CREATE
  }
  case object DELETE extends zio.aws.route53.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeAction =
      software.amazon.awssdk.services.route53.model.ChangeAction.DELETE
  }
  case object UPSERT extends zio.aws.route53.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.ChangeAction =
      software.amazon.awssdk.services.route53.model.ChangeAction.UPSERT
  }
}
