package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.ResourceDescription
import scala.jdk.CollectionConverters._
final case class ChangeBatch(
    comment: Optional[ResourceDescription] = Optional.Absent,
    changes: Iterable[zio.aws.route53.model.Change]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ChangeBatch = {
    import ChangeBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ChangeBatch
      .builder()
      .optionallyWith(
        comment.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.comment)
      .changes(changes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ChangeBatch.ReadOnly =
    zio.aws.route53.model.ChangeBatch.wrap(buildAwsValue())
}
object ChangeBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ChangeBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ChangeBatch =
      zio.aws.route53.model.ChangeBatch(
        comment.map(value => value),
        changes.map { item =>
          item.asEditable
        }
      )
    def comment: Optional[ResourceDescription]
    def changes: List[zio.aws.route53.model.Change.ReadOnly]
    def getComment: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("comment", comment)
    def getChanges
        : ZIO[Any, Nothing, List[zio.aws.route53.model.Change.ReadOnly]] =
      ZIO.succeed(changes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ChangeBatch
  ) extends zio.aws.route53.model.ChangeBatch.ReadOnly {
    override val comment: Optional[ResourceDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.route53.model.primitives.ResourceDescription(value))
    override val changes: List[zio.aws.route53.model.Change.ReadOnly] = impl
      .changes()
      .asScala
      .map { item =>
        zio.aws.route53.model.Change.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ChangeBatch
  ): zio.aws.route53.model.ChangeBatch.ReadOnly = new Wrapper(impl)
}
