package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{CollectionVersion, UUID}
import scala.jdk.CollectionConverters._
final case class ChangeCidrCollectionRequest(
    id: UUID,
    collectionVersion: Optional[CollectionVersion] = Optional.Absent,
    changes: Iterable[zio.aws.route53.model.CidrCollectionChange]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest = {
    import ChangeCidrCollectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest
      .builder()
      .id(UUID.unwrap(id): java.lang.String)
      .optionallyWith(
        collectionVersion.map(value =>
          CollectionVersion.unwrap(value): java.lang.Long
        )
      )(_.collectionVersion)
      .changes(changes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ChangeCidrCollectionRequest.ReadOnly =
    zio.aws.route53.model.ChangeCidrCollectionRequest.wrap(buildAwsValue())
}
object ChangeCidrCollectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ChangeCidrCollectionRequest =
      zio.aws.route53.model.ChangeCidrCollectionRequest(
        id,
        collectionVersion.map(value => value),
        changes.map { item =>
          item.asEditable
        }
      )
    def id: UUID
    def collectionVersion: Optional[CollectionVersion]
    def changes: List[zio.aws.route53.model.CidrCollectionChange.ReadOnly]
    def getId: ZIO[Any, Nothing, UUID] = ZIO.succeed(id)
    def getCollectionVersion: ZIO[Any, AwsError, CollectionVersion] =
      AwsError.unwrapOptionField("collectionVersion", collectionVersion)
    def getChanges: ZIO[Any, Nothing, List[
      zio.aws.route53.model.CidrCollectionChange.ReadOnly
    ]] = ZIO.succeed(changes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest
  ) extends zio.aws.route53.model.ChangeCidrCollectionRequest.ReadOnly {
    override val id: UUID = zio.aws.route53.model.primitives.UUID(impl.id())
    override val collectionVersion: Optional[CollectionVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionVersion())
        .map(value => zio.aws.route53.model.primitives.CollectionVersion(value))
    override val changes
        : List[zio.aws.route53.model.CidrCollectionChange.ReadOnly] = impl
      .changes()
      .asScala
      .map { item =>
        zio.aws.route53.model.CidrCollectionChange.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ChangeCidrCollectionRequest
  ): zio.aws.route53.model.ChangeCidrCollectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
