package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ChangeId
import scala.jdk.CollectionConverters._
final case class ChangeCidrCollectionResponse(id: ChangeId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse = {
    import ChangeCidrCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse
      .builder()
      .id(ChangeId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ChangeCidrCollectionResponse.ReadOnly =
    zio.aws.route53.model.ChangeCidrCollectionResponse.wrap(buildAwsValue())
}
object ChangeCidrCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ChangeCidrCollectionResponse =
      zio.aws.route53.model.ChangeCidrCollectionResponse(id)
    def id: ChangeId
    def getId: ZIO[Any, Nothing, ChangeId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse
  ) extends zio.aws.route53.model.ChangeCidrCollectionResponse.ReadOnly {
    override val id: ChangeId =
      zio.aws.route53.model.primitives.ChangeId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ChangeCidrCollectionResponse
  ): zio.aws.route53.model.ChangeCidrCollectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
